//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------
using NUnit.Framework;
using static Unity.Mathematics.math;
using Burst.Compiler.IL.Tests;

namespace Unity.Mathematics.Tests
{
    [TestFixture]
    public class TestDouble4x4
    {
        [TestCompiler]
        public static void double4x4_zero()
        {
            TestUtils.AreEqual(double4x4.zero.c0.x, 0.0);
            TestUtils.AreEqual(double4x4.zero.c0.y, 0.0);
            TestUtils.AreEqual(double4x4.zero.c0.z, 0.0);
            TestUtils.AreEqual(double4x4.zero.c0.w, 0.0);
            TestUtils.AreEqual(double4x4.zero.c1.x, 0.0);
            TestUtils.AreEqual(double4x4.zero.c1.y, 0.0);
            TestUtils.AreEqual(double4x4.zero.c1.z, 0.0);
            TestUtils.AreEqual(double4x4.zero.c1.w, 0.0);
            TestUtils.AreEqual(double4x4.zero.c2.x, 0.0);
            TestUtils.AreEqual(double4x4.zero.c2.y, 0.0);
            TestUtils.AreEqual(double4x4.zero.c2.z, 0.0);
            TestUtils.AreEqual(double4x4.zero.c2.w, 0.0);
            TestUtils.AreEqual(double4x4.zero.c3.x, 0.0);
            TestUtils.AreEqual(double4x4.zero.c3.y, 0.0);
            TestUtils.AreEqual(double4x4.zero.c3.z, 0.0);
            TestUtils.AreEqual(double4x4.zero.c3.w, 0.0);
        }

        [TestCompiler]
        public static void double4x4_identity()
        {
            TestUtils.AreEqual(double4x4.identity.c0.x, 1.0);
            TestUtils.AreEqual(double4x4.identity.c0.y, 0.0);
            TestUtils.AreEqual(double4x4.identity.c0.z, 0.0);
            TestUtils.AreEqual(double4x4.identity.c0.w, 0.0);
            TestUtils.AreEqual(double4x4.identity.c1.x, 0.0);
            TestUtils.AreEqual(double4x4.identity.c1.y, 1.0);
            TestUtils.AreEqual(double4x4.identity.c1.z, 0.0);
            TestUtils.AreEqual(double4x4.identity.c1.w, 0.0);
            TestUtils.AreEqual(double4x4.identity.c2.x, 0.0);
            TestUtils.AreEqual(double4x4.identity.c2.y, 0.0);
            TestUtils.AreEqual(double4x4.identity.c2.z, 1.0);
            TestUtils.AreEqual(double4x4.identity.c2.w, 0.0);
            TestUtils.AreEqual(double4x4.identity.c3.x, 0.0);
            TestUtils.AreEqual(double4x4.identity.c3.y, 0.0);
            TestUtils.AreEqual(double4x4.identity.c3.z, 0.0);
            TestUtils.AreEqual(double4x4.identity.c3.w, 1.0);
        }

        [TestCompiler]
        public static void double4x4_operator_equal_wide_wide()
        {
            double4x4 a0 = double4x4(-135.18925172425304, -49.094127439471947, 169.12980778940482, 240.80529772527757, 314.73919382446411, 442.39301916695808, 177.92444881141398, 335.53340283759564, 168.1544516869609, 350.72955982327903, 367.17843668869625, 46.941470406456574, 188.76415094582558, -97.211392209497944, -293.3210057193977, -234.82292353120766);
            double4x4 b0 = double4x4(-220.01464591734793, 66.980020792679852, 499.20158576369363, -371.113114291389, 208.44865212610398, 390.80369133074009, -72.443806920407269, 362.97643273089841, 194.6783255053117, 471.6448635867074, -404.04466719368691, -144.69675476136467, -494.44664334433463, -252.97038209297244, 234.41711746641306, 398.72397465199413);
            bool4x4 r0 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a0 == b0, r0);

            double4x4 a1 = double4x4(417.03371329653714, 26.386443388828297, 269.24572265764959, 29.474191440955792, 479.48521469509467, -237.23094355186026, -221.98371349181224, -506.67253255596034, -22.98943401453522, 487.26083802024868, -419.73195596213077, 337.20329324212082, 245.04388367619549, 390.21586984685428, 84.412977973191573, 434.20789142800868);
            double4x4 b1 = double4x4(260.42872083393331, 370.14420502732708, 89.579862397899774, -434.81684347373289, -109.84533815730612, 336.9730161805511, -409.15498156526826, 500.38755273278218, -174.08180888652885, 395.10115379612012, 350.33930723291792, -243.14458453056614, -416.39737267810727, 151.5764511337394, -18.224320181749931, -431.67792364194895);
            bool4x4 r1 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a1 == b1, r1);

            double4x4 a2 = double4x4(-68.728424342688356, 485.76997803420295, 413.16974969076443, -418.26928992675118, -346.79586593564409, 504.15964889161273, 345.18627635817336, -434.71304126955243, -499.77411078837429, 282.01905192156278, 259.15627944616426, 306.4559306141249, 435.22542759181249, -386.89967864886842, 211.3639925510455, -7.2298214469244044);
            double4x4 b2 = double4x4(-468.3309554850361, 429.49572797748056, 477.38919781026857, -433.42541071093893, 273.54640329701192, -34.976225153997632, 221.96845422590548, 85.919132511093835, -85.598944942280184, 392.76080316713114, -117.92407732732784, -445.30559393638077, -242.46897208060557, 173.64309533575693, 389.8977403072164, -14.290465123155343);
            bool4x4 r2 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a2 == b2, r2);

            double4x4 a3 = double4x4(-32.053229585314739, -106.29855947676049, -382.92495959947121, -424.78219695798225, -267.81251895977766, 229.8970197317642, 358.17965834130518, -76.3308608887395, -493.68433140855484, 139.35056192211368, 211.75662789668729, -178.83420308811321, -262.78688609916105, 506.27030038566807, 352.288876459137, -132.78940326198443);
            double4x4 b3 = double4x4(-317.55301990991131, -265.65275800677614, -424.16826053344096, 11.621368175196153, 408.68624873118767, -181.27835925914269, -139.82048160388155, -488.92457054971, -207.7032626642395, -341.9880770845283, -470.55291173912258, -462.80434701536052, 419.07557197058372, 143.63872177137, -79.91238526250811, -224.69360624286048);
            bool4x4 r3 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a3 == b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_equal_wide_scalar()
        {
            double4x4 a0 = double4x4(65.671194345537174, 404.41550440546848, -269.7301577393572, 83.630607882342588, 152.99450476141385, -155.86829836474186, 314.67125597348024, 386.36515325417986, 290.04894007837811, -132.63519460178691, -65.667489797653388, -69.683271678948415, -191.19075521789063, 186.84520086406042, -232.89569221851218, -319.14406481345372);
            double b0 = (-155.8157547245807);
            bool4x4 r0 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a0 == b0, r0);

            double4x4 a1 = double4x4(-49.701092981594172, 333.39685193328046, 386.377503336583, -296.70189084517858, -309.11719741910565, 141.54237968360189, -227.32334314441465, 83.872881689981, -410.91687483848858, 110.50128345866744, -390.10359329269437, 36.574313896044259, -427.54144235492754, -268.17085111707956, 175.81170590958175, -193.47994694182648);
            double b1 = (-300.88189925853248);
            bool4x4 r1 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a1 == b1, r1);

            double4x4 a2 = double4x4(291.05195368968509, -429.87391849508225, -275.15694750247383, -56.332365300661138, -95.835959717554942, -124.86533385369245, 253.00615632394613, -300.50952949212376, 314.86654320120181, 195.61619886924336, -26.128909838445907, -284.7746838465215, -242.67206560944771, 140.36059886792702, 505.64434194268858, 506.5379443143205);
            double b2 = (423.97165723516218);
            bool4x4 r2 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a2 == b2, r2);

            double4x4 a3 = double4x4(-502.369801993654, 87.367303650531539, -433.136377297871, -149.62691480928424, -358.698557305475, -249.12687527813335, 469.59318540505751, 511.75772619236159, 51.911379599902489, 245.63041817659064, 192.77484926617467, -162.20916064186446, 205.59038243330565, -376.46434348470734, 270.52080429276486, -388.203324737122);
            double b3 = (-249.51763236220813);
            bool4x4 r3 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a3 == b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_equal_scalar_wide()
        {
            double a0 = (36.383921878591195);
            double4x4 b0 = double4x4(-400.48919958644046, -71.286823544319191, 156.97811491646712, -225.23872791288363, 499.14180993435059, -211.97992358542047, 428.31192394174263, -489.50133322621758, -5.6915457275190988, -30.865948453017495, -362.98307221149241, 184.50319322594589, -160.47062142215231, 316.66882315122928, 390.36923879681581, 505.10510301268891);
            bool4x4 r0 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a0 == b0, r0);

            double a1 = (-294.64870967280524);
            double4x4 b1 = double4x4(443.19909283295226, 96.559236333034619, -257.01294601010761, -245.05497538533757, 326.46485176983515, -23.959890138339176, -168.6948808025079, 386.24859279498855, -227.09065185631192, -336.61242524562982, 365.10812752559229, -405.39083952707745, -473.99549959320365, 298.43535174915348, -149.86322386090796, 450.06639191604518);
            bool4x4 r1 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a1 == b1, r1);

            double a2 = (153.47643358701669);
            double4x4 b2 = double4x4(56.287803437694834, 39.342111844263059, -350.40371744260369, -482.71723221368961, 239.96540772168214, -3.4060323254233253, -1.4948394305514512, 105.96042184995508, 151.53752787017152, 63.283196240329744, -289.69317378182575, 137.55377942768564, -247.66646945088473, -339.42056409428858, 23.238285313937013, 21.177870045033274);
            bool4x4 r2 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a2 == b2, r2);

            double a3 = (477.036560995987);
            double4x4 b3 = double4x4(-411.31815524181263, 122.39710408188273, -401.49883503536637, -230.56110273607129, -214.95405135627561, 464.67306659402004, -186.32700428102493, -99.487320707872186, 214.23246179066246, -387.36749833979059, -448.79620358384966, 427.88950630085981, -43.696046134315452, 182.69869979782902, 298.88015164941555, 246.43680130990072);
            bool4x4 r3 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a3 == b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_not_equal_wide_wide()
        {
            double4x4 a0 = double4x4(279.99414576217259, -43.342018386042696, -465.72473523846116, 317.46655645848557, 85.714987079480238, 360.89050572034466, 366.08152668833804, 154.5428384070018, 332.426219856565, 397.11323160543725, -431.3749584776233, 489.01079319837072, 398.43358320669904, -489.81794594685454, 171.4049242340983, -67.829682620162941);
            double4x4 b0 = double4x4(-460.912120318465, -476.00904844515446, 468.13642070635058, -341.01254312182431, -62.658060341448561, -458.80166718866752, -457.73023316717251, -59.523265627922171, 3.024243117787023, 155.81276352508587, -19.839918384253963, -6.0169332055453992, -406.20792145571107, -102.42070083619126, -40.362921018322425, 452.67542645552919);
            bool4x4 r0 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a0 != b0, r0);

            double4x4 a1 = double4x4(-192.27871498478515, 227.84082494854965, 62.138187675801191, 262.18648755838467, -404.05309052209049, 34.449567572423007, -204.79578719138902, -285.41180314003111, -72.206820760018559, 444.74925228801987, 238.81779991780309, 365.18011563139976, -437.92291351683571, -362.4426316518535, 445.95436665320506, -0.41746735592255391);
            double4x4 b1 = double4x4(93.257571979080126, -258.37806689849964, -184.04980405794913, -379.23531192319251, -370.68729537105526, -255.94724023339677, 29.055771602809273, 322.40763226263584, 415.07170005099465, -467.72613189542949, -433.78467508488552, -212.16593585357344, 474.67491481950265, 452.48318621724991, -92.112742705323171, -385.92209190219739);
            bool4x4 r1 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a1 != b1, r1);

            double4x4 a2 = double4x4(-506.82837772128562, 245.47704779611763, -173.57105811572217, 390.33854669627669, 252.83775555940235, 47.865854047176413, 457.710514043323, -313.22114601415637, 391.20388168432, 481.7861199238273, 26.887826693657757, -298.14237346227389, 240.07745634768037, -332.45515338166388, -333.60717240609563, -313.18967857639757);
            double4x4 b2 = double4x4(420.21507926481547, -239.17604529074208, -99.079094694498508, 4.4760239145141441, 264.34854352862976, 451.31233689343196, 232.95803343176749, -142.62218839611029, -300.22557820949032, 268.33322418310365, -112.1035507247334, -270.49403989989963, -71.9932391978769, 99.463272856298545, 321.70330134113476, 200.05965218323263);
            bool4x4 r2 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a2 != b2, r2);

            double4x4 a3 = double4x4(141.7301719848673, -261.11886251211115, 295.57872380669164, -16.021309621642047, -487.26684664528204, -208.5638874548319, 30.349470867938066, -157.87644989689647, 275.896060833659, -450.72069546707007, -61.898862629150415, 99.190081404144962, 206.35745272708937, 32.746498361577551, -278.62394131283463, -173.91680367939023);
            double4x4 b3 = double4x4(-91.628340525379542, -113.0108664562045, 465.76424215071097, -485.12772606552005, -71.726771626494269, 486.46925638917332, 425.86777873796768, -158.88094694860325, 292.17955674425673, 234.17994486269538, 243.24930846097379, 117.27517300344778, 3.9710876960173209, 410.42218108215468, -221.12472616002185, 443.13445421826771);
            bool4x4 r3 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a3 != b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_not_equal_wide_scalar()
        {
            double4x4 a0 = double4x4(-155.44111282911206, -19.426602134214079, 174.63305409934048, 507.9207296352464, 59.177048472304364, 171.15146430356026, -58.923273352404692, -398.17684835855704, 492.20105361016522, -165.24150879925185, 270.34102333259818, -380.24326222960059, 501.8990516615562, -134.34545642433011, 458.40042302496749, 46.771004937016869);
            double b0 = (-393.41354173860213);
            bool4x4 r0 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a0 != b0, r0);

            double4x4 a1 = double4x4(161.45995123752391, -145.61239559278471, -0.44992661497087738, 350.46143047439932, 202.22103724359579, 242.66402232025939, 382.67707675633812, -468.96794221781562, -497.45947789468778, -80.932258882062627, -328.58774844211888, -506.49033260088896, 449.34814640942409, 210.77098784724762, 249.18179690520367, -338.46854058768065);
            double b1 = (261.51423442620512);
            bool4x4 r1 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a1 != b1, r1);

            double4x4 a2 = double4x4(229.67068420614612, 317.28609314434516, 401.93959612489664, 210.98484502126689, -147.09631616766393, -193.39904531901658, 207.73136410849702, 284.39206208120663, -509.0852923379677, 414.30764718274941, -52.294460082563774, -140.43793660981487, -316.78779402225643, -358.69683592333308, 312.31897249460178, 270.62946260656668);
            double b2 = (-76.543291365980792);
            bool4x4 r2 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a2 != b2, r2);

            double4x4 a3 = double4x4(-140.01671153866533, 113.13720446132925, 479.699595436314, 6.0974566964886208, -83.634578982197922, 249.90937554552659, 303.95597734300236, 464.88867185306208, 44.636526366992143, -259.91627681437706, -242.33552491028587, -403.68651575766808, -469.14709279925893, 135.98750335350053, -490.84077357260549, 470.22527835808012);
            double b3 = (108.9106157333174);
            bool4x4 r3 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a3 != b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_not_equal_scalar_wide()
        {
            double a0 = (478.35313938481409);
            double4x4 b0 = double4x4(459.55319592894671, 436.45324369727314, -488.71416806090349, 392.76794475725296, -266.73665369056937, 338.55788270503183, -338.10012475498957, -152.3145445102428, -452.82067868338, 209.43931422449612, 50.107968592135194, 372.4343656843688, -488.0213141329686, 489.74075697816011, 270.40006149485714, -472.8467831429312);
            bool4x4 r0 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a0 != b0, r0);

            double a1 = (-286.85046090132113);
            double4x4 b1 = double4x4(-384.69186681541237, 443.42352959300558, 358.74720900074919, -15.414077527548216, -342.17916194637269, 468.96750400446706, -130.56808501601597, 401.7858013593526, -268.35225761511936, -239.231014124691, 411.38655800902586, 139.76932460617707, 334.52206031164246, -223.62923036498449, -12.488468414400018, 113.46889238872984);
            bool4x4 r1 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a1 != b1, r1);

            double a2 = (-189.65225204716074);
            double4x4 b2 = double4x4(-212.84655127900027, 306.1256321902041, -178.33037885386977, 382.14199203166277, -340.86559478420094, -17.580244787773211, -409.87484498036787, -349.70166914057995, 275.85432756871649, -229.37194906425287, -127.50573283410898, 90.753436369240944, -422.08713574990963, -2.4475424301100475, -280.55170954417054, -484.37435959483236);
            bool4x4 r2 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a2 != b2, r2);

            double a3 = (-33.76342226647);
            double4x4 b3 = double4x4(374.59386962214194, 437.0923590311279, 286.22582949615355, -18.232783087637642, 289.73235787531939, 479.48573969280619, 153.85391695511248, 502.98214339790036, -510.38439607545007, 65.78889682972283, -237.48668276401548, 219.91613088358008, -275.3427389950225, -78.931455410519334, -449.40356299346479, -253.03452670436099);
            bool4x4 r3 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a3 != b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_less_wide_wide()
        {
            double4x4 a0 = double4x4(51.710243010758518, -313.85556450200062, 283.04767359562572, 235.02188621974642, 44.0783565249659, -207.25566659088042, 3.3829410091894943, -144.30134326978651, -69.369597705718888, -135.66796762108243, -194.78736576567746, -33.473868147225062, -19.675088653189619, 423.23796697297973, -71.698315415390937, -501.88598870760109);
            double4x4 b0 = double4x4(-261.83523881707117, -19.810742149041403, -149.25882084167506, 205.99822316225539, -306.02438535635565, 102.12168006884008, 231.90633760760829, 179.49885305180158, 473.22488496882136, 15.891647107848712, 270.04990614114786, 490.91400240869916, -185.73412164753961, 76.433086669274189, 97.75231246731812, 419.30080600236579);
            bool4x4 r0 = bool4x4(false, true, false, false, false, true, true, true, true, true, true, true, false, false, true, true);
            TestUtils.AreEqual(a0 < b0, r0);

            double4x4 a1 = double4x4(7.6438391244242894, 302.26289214857991, -140.55051786291904, -436.586703265359, -351.441728040316, 364.97084896870467, 301.894133946809, 407.55097336673691, 269.10777128353141, 462.98824737173891, 223.8841808884797, -287.18923319838439, 283.63862933015389, 511.86434650414822, -60.496787814654795, -234.30346142235373);
            double4x4 b1 = double4x4(73.953208242521214, 481.03232382285978, 7.00747371046225, -7.3240954910051528, -413.07575793428146, -154.1188920261892, 449.20288989003882, 502.01430797111914, -382.31586259525079, 251.53517758638372, 143.17396957388803, 293.66033686961066, -292.76956691069972, -43.218204756834666, -353.41120044952777, 458.32604405764766);
            bool4x4 r1 = bool4x4(true, true, true, true, false, false, true, true, false, false, false, true, false, false, false, true);
            TestUtils.AreEqual(a1 < b1, r1);

            double4x4 a2 = double4x4(-316.13839664875456, -417.52215905558421, 441.6434454590285, -191.95062908527939, 397.81158823418036, -144.66662485183525, 417.0790571724433, -322.9801315381099, -81.285095014276521, 319.32531538574267, 146.76406509557933, -316.58337488611386, -150.85755855909434, -314.60630550729405, 7.14312720631392, -458.82730767635036);
            double4x4 b2 = double4x4(-114.55647259324627, 441.42973276666817, -113.33366709264629, 435.622928583819, 383.65612786992267, -293.711607831396, -391.35497612103586, 43.122021456771563, 433.2236590018606, -201.38245282014014, -241.42116629398481, 376.46986955053637, -503.39744472103075, -359.78095095221931, 118.63150149147566, -510.03052759078821);
            bool4x4 r2 = bool4x4(true, true, false, true, false, false, false, true, true, false, false, true, false, false, true, false);
            TestUtils.AreEqual(a2 < b2, r2);

            double4x4 a3 = double4x4(333.22770348807228, -349.98049537743464, 354.72504894562303, -451.62913748790936, 321.6347664900286, 365.72358935220336, -224.15940557427678, 388.58127969716736, -481.78943537258982, -473.93310974255814, -160.73651583527055, -200.43802103793155, -309.97309770713241, 80.287291325762567, -310.72736158535224, -83.520198622495);
            double4x4 b3 = double4x4(418.64480491105689, -95.549393459944724, 478.12124060006875, -129.55856162382224, -484.63468121208, 352.22805301855692, -505.47762536698843, 162.99360545118975, -43.25767495262329, 18.279553183484609, 479.07899139778647, 437.28276964523025, -281.99202860612047, 433.04089018005914, -344.16967813306007, -232.81991325729524);
            bool4x4 r3 = bool4x4(true, true, true, true, false, false, false, false, true, true, true, true, true, true, false, false);
            TestUtils.AreEqual(a3 < b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_less_wide_scalar()
        {
            double4x4 a0 = double4x4(-221.86977325280651, -121.54646807608498, -97.52392511140738, 479.88107775146193, 67.118990214131259, 137.32880574899207, 282.96659601990439, 258.27909362422258, -111.41316061439608, -288.08113278452356, 82.665427008022334, -361.64292042406413, -68.088202269788951, 12.788020378345664, -66.703050406045747, -78.762971199472872);
            double b0 = (199.06751808853244);
            bool4x4 r0 = bool4x4(true, true, true, false, true, true, false, false, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a0 < b0, r0);

            double4x4 a1 = double4x4(25.727694284975428, -330.442660724019, -48.920521520506838, 359.60440914686978, -8.15008759878117, 241.27682101040932, -183.43778165776178, 423.02713580756779, -334.62272349680904, -98.315578744893685, 300.41017617863145, 297.92523850962766, -492.108162870681, -395.80724806143309, 95.788790032169231, -220.62145791790516);
            double b1 = (101.37087182950734);
            bool4x4 r1 = bool4x4(true, true, true, false, true, false, true, false, true, true, false, false, true, true, true, true);
            TestUtils.AreEqual(a1 < b1, r1);

            double4x4 a2 = double4x4(-455.37556740985048, -296.37211884948056, 272.4883617239484, 360.20793097103387, 389.7274403002707, 68.736721786082171, -400.61523384629527, -85.469117442830054, -467.70215604626674, -51.387892031757133, 201.76466927387037, -47.8412668927765, -180.74006255936814, -409.01566929789988, 229.6990183469369, 176.19784816363722);
            double b2 = (360.29156344025);
            bool4x4 r2 = bool4x4(true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a2 < b2, r2);

            double4x4 a3 = double4x4(-410.45517439882047, -20.246482620130507, 150.79782230723549, -69.4741823996763, -304.78239431268651, 149.17671091350576, -426.0861434536456, -455.14605805610586, -110.2582862890597, -276.35561550611425, 494.55641984127294, 472.35385511459492, -131.30499774371509, -404.27388472309053, 498.8766369758531, 370.97853749384103);
            double b3 = (-264.43480766212326);
            bool4x4 r3 = bool4x4(true, false, false, false, true, false, true, true, false, true, false, false, false, true, false, false);
            TestUtils.AreEqual(a3 < b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_less_scalar_wide()
        {
            double a0 = (-250.4849370692321);
            double4x4 b0 = double4x4(-377.19654887597846, -505.14754104295167, 375.92672198634909, 110.17393474940855, -118.09757452742082, -40.45089079833167, -299.74430932651478, 31.437125935888389, -458.904539560389, 13.684679276163024, -458.50690839183841, 248.27646624682302, 389.23142999654237, 488.74553679337055, -221.63786731550368, -424.26720329013989);
            bool4x4 r0 = bool4x4(false, false, true, true, true, true, false, true, false, true, false, true, true, true, true, false);
            TestUtils.AreEqual(a0 < b0, r0);

            double a1 = (249.05904948388184);
            double4x4 b1 = double4x4(-22.136127720650336, -442.24773928255206, -340.85755721705851, -95.1117256130612, 15.409410245441563, 87.292497437117845, 495.06764220402931, 316.01850309782594, -125.56811505442863, 122.16476803746298, 96.75540046429046, -228.90633808304852, -143.95269662884652, -230.238279688283, -327.61262885090548, 103.39802770661095);
            bool4x4 r1 = bool4x4(false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a1 < b1, r1);

            double a2 = (434.488835775521);
            double4x4 b2 = double4x4(-157.45019228637693, 190.57215914063727, 108.25831871305513, 132.55076056930739, -431.51522155828553, -192.20350727448402, -431.83499284825984, -85.581249515331024, 328.67053977058765, 273.5778516612844, -178.66905816768718, 352.63627235621038, -82.605815687498932, 238.90886675515628, 291.3353070185218, 183.35733875229835);
            bool4x4 r2 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a2 < b2, r2);

            double a3 = (-185.03260597262187);
            double4x4 b3 = double4x4(-179.35502895124023, -331.53868189991391, 59.284426478335831, 356.62678854382909, 119.39404087857997, -80.440038480069518, 392.85907978231978, 306.15543165158272, -504.52945947299219, 349.38434116420535, 115.50029020919476, -251.65653598106303, 197.0481570684575, -268.07704103555392, 381.10572045906713, -367.12156145978793);
            bool4x4 r3 = bool4x4(true, false, true, true, true, true, true, true, false, true, true, false, true, false, true, false);
            TestUtils.AreEqual(a3 < b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_greater_wide_wide()
        {
            double4x4 a0 = double4x4(-229.29066501804192, 505.536608216137, -73.80706862071861, 100.29203777215071, -419.21478124112582, -159.55974753180504, -396.7703608929973, 127.03739482119556, 489.13989733585151, 51.91890885863404, 155.38475544535777, -135.63165027258526, -425.97813554572787, -228.430505143679, 383.03834909155887, 136.53358298937496);
            double4x4 b0 = double4x4(-445.84502407808088, -420.03529210576568, 299.02440108872224, -13.880978829171966, 151.56173593903043, -163.5094302461992, -391.09603733154762, 479.2837710228207, -77.674873149802409, -46.5841996886694, -415.37701888353422, 71.466978344818131, -206.06102643071722, 360.83628218287424, 236.96878658838978, 14.550342328171382);
            bool4x4 r0 = bool4x4(true, true, false, true, false, true, false, false, true, true, true, false, false, false, true, true);
            TestUtils.AreEqual(a0 > b0, r0);

            double4x4 a1 = double4x4(8.602427725029429, -251.3243674018068, -345.954920691417, -170.565928777012, -293.25441588706076, 139.1249764613458, 214.3030732675935, 238.76991211565678, 105.53519086983761, -170.92529280992471, 26.98023964230913, -188.92831405854241, 201.78662619450438, -506.05715656003781, 15.454906232401186, 115.08067207926911);
            double4x4 b1 = double4x4(364.735178402036, -159.0612996365229, 226.63117490831348, 182.79602512288659, 341.83937398616195, -79.130463875425278, -247.29681956362765, 164.58913882290437, -352.15977327533056, 9.8226540134394327, 186.72162613026876, -325.91364613450764, -77.930370128681147, -379.74604219000139, 251.45575558927646, -144.1835678295156);
            bool4x4 r1 = bool4x4(false, false, false, false, false, true, true, true, true, false, false, true, true, false, false, true);
            TestUtils.AreEqual(a1 > b1, r1);

            double4x4 a2 = double4x4(-496.97184705034448, 339.88814202877143, 372.22833007025918, 313.2386917142378, -419.10894437279035, -265.32978380160864, -42.501995344880015, 369.16390507722451, 67.169061453626, -256.69890868696336, -104.10592060168551, 499.57010268586225, 41.663492460578482, 151.15207416897272, 220.68833146835129, -344.65888110951471);
            double4x4 b2 = double4x4(337.88991014002352, -249.50553929503332, -225.90130554228148, -249.49127757246202, 381.12288373574745, 325.54538145919582, 455.49881360283996, 333.31868401789973, 118.98035603341668, 223.19812236688949, -385.28907102406447, 333.88080159476067, -437.41072126729915, 243.97544943726405, -302.81988658701061, -32.710171476337223);
            bool4x4 r2 = bool4x4(false, true, true, true, false, false, false, true, false, false, true, true, true, false, true, false);
            TestUtils.AreEqual(a2 > b2, r2);

            double4x4 a3 = double4x4(-285.24129809310716, -94.158616825080742, -75.18496159239902, 304.3608087526452, -153.39846498956831, -83.06840161377022, -59.948590068122655, 228.58834921037237, 64.90572479409434, 65.08489635637261, -3.845335723760229, 471.92235277216992, 350.31980745416126, 220.83096824438826, 134.94662028874575, 41.820390959186625);
            double4x4 b3 = double4x4(-228.69145570913861, 388.41316312757, -23.724548589309961, -180.56350358788086, -433.43401523746275, 157.85735590656168, -2.4736955177382356, 258.28781259166442, -327.37584057793759, 408.47455019898462, 403.88254971237973, 400.31722397371993, -505.99265956598924, 297.63905133755839, -442.73675772302636, 395.71094221422027);
            bool4x4 r3 = bool4x4(false, false, false, true, true, false, false, false, true, false, false, true, true, false, true, false);
            TestUtils.AreEqual(a3 > b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_greater_wide_scalar()
        {
            double4x4 a0 = double4x4(11.156317000815761, -411.02322382993214, 385.88556188432756, -485.10304831206008, -491.18003033622171, 405.17534632476759, 173.57509740329124, 69.269281181166548, 501.30683183172107, -367.027771405423, -86.124509613087639, -489.09058998948456, -172.51816066192379, -18.149639853346002, -236.41493498367021, -238.8945134798505);
            double b0 = (-302.81693877969724);
            bool4x4 r0 = bool4x4(true, false, true, false, false, true, true, true, true, false, true, false, true, true, true, true);
            TestUtils.AreEqual(a0 > b0, r0);

            double4x4 a1 = double4x4(-27.239137900638923, 240.16453253485474, -481.47807930478734, 185.59438547193747, 33.294723764664809, -510.22814702905163, -183.28619607877278, -386.12766260007754, -13.638212448748845, -7.3478887115362568, -261.86596477304863, 52.24950768996473, 16.323217637987455, -410.51010985416832, -262.26747978025463, -458.25599000335484);
            double b1 = (471.77934072528933);
            bool4x4 r1 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a1 > b1, r1);

            double4x4 a2 = double4x4(-218.86613069235631, 290.57303752124915, 180.263321722049, -482.86394690110529, 100.70627574841785, 180.6725166685286, 501.31978749731547, -289.28097046971368, -25.849692595121326, 455.1624288294289, -63.3173549470107, -17.446765669363913, 53.017790103805169, 88.819595139855323, 182.3580006018085, -428.92720933860505);
            double b2 = (-34.692342535915031);
            bool4x4 r2 = bool4x4(false, true, true, false, true, true, true, false, true, true, false, true, true, true, true, false);
            TestUtils.AreEqual(a2 > b2, r2);

            double4x4 a3 = double4x4(408.336862515815, 495.17269753626204, 345.03004352423829, 337.5619315288784, 175.88833745563795, -412.79507680088051, 57.17175796310039, 413.02461428801746, 34.4581821125272, -99.476764963696155, -76.558937823660187, -494.98022650879818, -27.016385806266385, -468.51766155125466, -335.857029832833, 481.16540001387023);
            double b3 = (-460.19863698454509);
            bool4x4 r3 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true);
            TestUtils.AreEqual(a3 > b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_greater_scalar_wide()
        {
            double a0 = (453.54610201974685);
            double4x4 b0 = double4x4(-226.20441423459187, -423.46500487973213, 409.40550227156166, 453.87706277048073, 87.475727837288673, 113.79560308987072, 176.40926154721956, -140.44002944810319, -182.48286804113673, -158.29329188088576, -162.68531830733889, -193.328676075362, 230.18129955519987, -102.58784227379965, 392.5205878655056, -177.47865947404813);
            bool4x4 r0 = bool4x4(true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a0 > b0, r0);

            double a1 = (-10.295010809924008);
            double4x4 b1 = double4x4(-24.048938524000789, 172.44867499752377, 374.04800503982608, -368.99763958947619, -210.19528804076617, 149.47022325800276, -281.34327019441093, -100.46916608720511, 304.86444320569956, -361.52483360912879, -372.45236056505348, -33.909547583157917, -69.595290454847429, -460.43241498453187, -309.34166278938841, 486.13155602204222);
            bool4x4 r1 = bool4x4(true, false, false, true, true, false, true, true, false, true, true, true, true, true, true, false);
            TestUtils.AreEqual(a1 > b1, r1);

            double a2 = (471.92098138850224);
            double4x4 b2 = double4x4(479.36154411703421, -107.00416784500896, 331.63653746789157, -340.84013120310385, -384.21461147079924, -451.7265658097931, 467.97876355982328, -236.5691269545672, 44.654746314815611, -285.79786671595548, 42.7309816082618, 338.18510762703841, 274.01702202205411, -108.60437088301609, -211.37325606652223, -19.004157313613291);
            bool4x4 r2 = bool4x4(false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a2 > b2, r2);

            double a3 = (194.114679188521);
            double4x4 b3 = double4x4(395.75988668750961, -320.20625725398133, -384.86614316742225, 310.54374160922305, 495.99087380617436, -60.935228137734896, 178.74877246597259, 42.3462288576859, 294.61128463158911, -36.679563301000542, 36.861622112273039, 405.46951813505473, 399.11242241371065, -209.86087689635383, -365.34365551795048, -167.46023209740417);
            bool4x4 r3 = bool4x4(false, true, true, false, false, true, true, true, false, true, true, false, false, true, true, true);
            TestUtils.AreEqual(a3 > b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_less_equal_wide_wide()
        {
            double4x4 a0 = double4x4(240.09053169940159, 462.2131528622532, 293.08251561461134, -427.87067361728782, -405.5227226715175, 204.59190211286386, 294.670105832941, -327.56444445604666, -456.12326667091031, 282.3012408140587, 421.8811549720732, -311.71284809322697, 84.5674827492644, 447.24461647832982, -154.49435217422172, -424.36474986763892);
            double4x4 b0 = double4x4(-81.203838624620744, 493.63743876555816, -411.47211451617636, 99.164449499530974, -295.66769875943089, -480.46254824123463, 74.414040361723892, 260.916124226952, 306.17329730939741, 139.56480438055689, -505.75247955031341, -489.62680958659706, -280.03260267899958, 303.15991058161478, 511.19015788994272, -104.65973358259527);
            bool4x4 r0 = bool4x4(false, true, false, true, true, false, false, true, true, false, false, false, false, false, true, true);
            TestUtils.AreEqual(a0 <= b0, r0);

            double4x4 a1 = double4x4(36.684489505684269, 267.07029283562224, 307.89391937288167, -351.76015369582927, -157.36036570247279, 152.70902712303632, 372.26716750313858, 202.36828837281485, -77.043453014010311, 438.18483253856414, 260.28234088620275, 386.03408759927106, -281.49099053139378, -102.9300439837063, -346.71673099450618, -258.34119832624737);
            double4x4 b1 = double4x4(95.1465771641333, -125.6363432992419, 376.239777024947, -415.7747320680761, -47.481050275024529, 117.72210293529656, 469.37837264937275, -263.04235780567041, -216.00231109187115, 66.734246046624207, 99.218598173567329, 233.843011249715, 439.8399624488502, 61.115118293610976, -219.03058419890266, -404.71288056146022);
            bool4x4 r1 = bool4x4(true, false, true, false, true, false, true, false, false, false, false, false, true, true, true, false);
            TestUtils.AreEqual(a1 <= b1, r1);

            double4x4 a2 = double4x4(-383.30294889179197, -5.1470377469188975, 319.34374752610165, 465.02220485407031, 145.93345100522663, -215.07482991697026, -146.46150667334979, -349.8939770897357, 29.599108948185631, -131.79663640437491, -438.99467464862141, 147.05792553120193, 221.11248956486236, -356.14535276784807, -32.830178991346713, 442.94199892642996);
            double4x4 b2 = double4x4(-202.74836430454087, -312.47647133119244, 310.07189884319519, -320.3630436958573, 186.07597288213481, -42.637794752902266, 82.565048971476472, 127.18911009989176, 198.28697428400017, -450.49204108235057, 20.901004085736872, 449.46589133211683, -478.77271841409276, 380.05395692403147, 99.1247280105598, -450.32978150357019);
            bool4x4 r2 = bool4x4(true, false, false, false, true, true, true, true, true, false, true, true, false, true, true, false);
            TestUtils.AreEqual(a2 <= b2, r2);

            double4x4 a3 = double4x4(-301.13985194877716, -10.974948172911525, -37.474589603708409, -70.386105331772058, -169.02451594594146, 432.80079504139758, -197.70657190946235, -131.69548207693521, 277.7339395385859, -480.48399065457471, 424.76605220547231, -477.71820591283881, 162.19371016425714, -21.588960896054743, 154.21725161104337, 224.46713529548936);
            double4x4 b3 = double4x4(45.421907684496546, 63.015531807679508, 2.8447597040071742, 124.8846481427945, 246.54787623442144, -437.79363199593206, -83.32811764782673, 147.94396049712964, 281.880845916402, -33.003705278506345, -319.8491572438968, 107.79604702247127, 57.38707092096422, 286.11646594019442, -427.03175206996116, -465.19127700533312);
            bool4x4 r3 = bool4x4(true, true, true, true, true, false, true, true, true, true, false, true, false, true, false, false);
            TestUtils.AreEqual(a3 <= b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_less_equal_wide_scalar()
        {
            double4x4 a0 = double4x4(309.1924356469849, 69.673792633076118, -101.72418622939114, -315.97240629604664, -346.01106731314724, 424.15386577330241, -410.87006945669191, -483.90265320423185, 183.82114538169515, 320.44249287268258, -257.87003791419329, -386.801748694294, -182.9388249772316, 349.25012962392077, 485.31159304329731, 373.56911652794531);
            double b0 = (292.92427148154206);
            bool4x4 r0 = bool4x4(false, true, true, true, true, false, true, true, true, false, true, true, true, false, false, false);
            TestUtils.AreEqual(a0 <= b0, r0);

            double4x4 a1 = double4x4(259.15151822713744, -128.5255282523695, -43.874866744445114, 457.38574549992836, -77.638293064030961, 479.45184038553941, -499.51644372358754, -398.13294643821797, 402.48485893871862, 87.9161055497434, -502.17362308044619, 125.95081263685177, -54.493607308014134, 250.66739737739204, 97.942930982421558, 228.02151809820043);
            double b1 = (450.13007828692446);
            bool4x4 r1 = bool4x4(true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a1 <= b1, r1);

            double4x4 a2 = double4x4(-213.37865243357544, -24.82758070194518, -451.04158684752957, 429.57755132651778, -308.43429031429548, 355.16031114904229, -279.40712011950421, 181.6722582232544, -290.14875401656548, -184.84408411050407, 447.6939139066701, 168.88657696958933, 26.378954661255193, 392.55852789085293, 255.60484015923214, 162.16346867483276);
            double b2 = (42.260789175639275);
            bool4x4 r2 = bool4x4(true, true, true, false, true, false, true, false, true, true, false, false, true, false, false, false);
            TestUtils.AreEqual(a2 <= b2, r2);

            double4x4 a3 = double4x4(195.49629482789726, 357.55978720149017, 145.56185037715443, 363.80669014705654, -141.43743545442697, 102.22195224753671, -114.20774250580359, -429.83945985782867, -236.49592625186591, -175.762239776441, -420.69644637624566, -97.853465841083562, -273.68524731029072, -442.22490450470934, 156.18703110338515, -102.82326679249445);
            double b3 = (463.24875209445543);
            bool4x4 r3 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a3 <= b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_less_equal_scalar_wide()
        {
            double a0 = (-511.15238141974078);
            double4x4 b0 = double4x4(51.159012579898786, 340.44369022010062, 312.81429519914752, 354.19252626699983, 136.39671165142056, -94.767871185563422, 288.544332877055, 304.04282369466625, -148.61806089646092, -506.30010127755816, 27.581254256694251, 48.471146844546865, 104.88351326104419, -488.6858386884843, -480.43516968210935, 421.9366516647566);
            bool4x4 r0 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
            TestUtils.AreEqual(a0 <= b0, r0);

            double a1 = (239.72105299668431);
            double4x4 b1 = double4x4(-101.01844673092404, -283.95147551407638, -55.2435333986038, -455.80483147865385, 131.10721618081777, -461.69878099006542, -388.48285001725094, -258.93605125087129, -225.2235287284588, -116.01998215355911, -442.59525629626364, 297.33334579008317, 36.687250392831515, 485.09780930220052, 344.44564859217292, 237.59216724969087);
            bool4x4 r1 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, false);
            TestUtils.AreEqual(a1 <= b1, r1);

            double a2 = (230.39086471795611);
            double4x4 b2 = double4x4(-413.98479266370873, -215.90167794744565, 39.5603883450666, 22.947996388630941, -162.0605676928817, 236.73373352584133, -253.95195853614803, -204.71909985538531, -161.61653550044474, -64.3859322370896, -229.815656530585, -484.82564591096047, -135.04042989343424, 351.69478599712943, 111.82539778194644, -249.98255431371859);
            bool4x4 r2 = bool4x4(false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false);
            TestUtils.AreEqual(a2 <= b2, r2);

            double a3 = (435.80731769828469);
            double4x4 b3 = double4x4(2.8926103128551404, -338.66996089493387, 381.34663146610683, 456.652450058913, 432.051796399081, 290.14247121016615, 189.29714521639846, 101.12857751787112, -150.37975962012064, -490.74788903200437, 219.13958917331865, -505.29052209541692, 326.69468871070751, -479.39791057975867, 195.13560566452122, 322.878979594856);
            bool4x4 r3 = bool4x4(false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a3 <= b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_greater_equal_wide_wide()
        {
            double4x4 a0 = double4x4(-386.59181302906563, -157.12078221008215, 391.01526445477054, -511.88687133783793, -5.4220387960886569, 287.64527501149348, -122.53520184500849, 7.4814426933794493, 152.94642765491574, 48.986223482054811, 57.338148859021317, 300.46493138953338, 349.25705139211243, 85.749700824613569, -230.95330654408468, 418.7112159294594);
            double4x4 b0 = double4x4(153.44301350109424, 49.892483019219981, 78.025787628267835, 138.81373292711271, -225.51057802211056, -339.35611335344436, -373.302078182484, 364.9358934671319, -322.71539870030961, 125.47818165900105, -25.776589167200314, 297.51890792395864, 73.222349439385539, 462.78374288174496, 393.19134515951919, -95.001432224643168);
            bool4x4 r0 = bool4x4(false, false, true, false, true, true, true, false, true, false, true, true, true, false, false, true);
            TestUtils.AreEqual(a0 >= b0, r0);

            double4x4 a1 = double4x4(-131.03991824530061, -126.51221257378916, -156.81847841889527, 422.37748761772059, -413.08933348818186, 219.44273553576443, 35.591133372667741, 447.18153521380464, -223.49299560463663, 302.12299194099523, 459.85272834256887, -347.12802879285442, 364.97808211156075, 212.63543162710755, 504.27608680365427, -142.23296052880255);
            double4x4 b1 = double4x4(381.35702556248611, 93.031928344178937, 254.25326287665087, 90.672789377473691, 348.93816892660141, 161.33763106229605, 79.435611046587837, 420.24346824187944, 453.68485209610537, -154.0116427661905, -97.290078923706915, 151.18477613813468, 57.360309865959152, -194.207084984615, -462.67061421958294, 113.38661604439221);
            bool4x4 r1 = bool4x4(false, false, false, true, false, true, false, true, false, true, true, false, true, true, true, false);
            TestUtils.AreEqual(a1 >= b1, r1);

            double4x4 a2 = double4x4(-132.22179395156996, 303.68380489185631, 265.21013439130513, 9.75437188602723, -233.09288631803025, 26.567515147182917, 266.78067529703526, -250.0722254487091, 138.0408142255809, 174.27673848638165, -420.93164678147605, -42.854160567211977, 216.48505435534059, 240.05384623261818, -470.38216875045663, 98.396702573819425);
            double4x4 b2 = double4x4(-129.35329276386335, 8.1077725925052846, 426.44951434920051, 410.69316477826476, 470.31343410458112, 220.39997993241991, -372.87269967276262, -242.17855965447546, 177.50623258273413, -172.63815864019011, 60.722858695649961, 478.25016067840636, 234.30301128807616, 297.82121171514564, 104.58457260233558, -462.41871926859892);
            bool4x4 r2 = bool4x4(false, true, false, false, false, false, true, false, false, true, false, false, false, false, false, true);
            TestUtils.AreEqual(a2 >= b2, r2);

            double4x4 a3 = double4x4(-20.828870544596043, -218.44057498613398, 287.75180615473153, -356.96666614942563, -68.069519789921856, -432.91875644816025, 388.14240592911017, 396.40410084109942, -204.5674646853318, 179.7521007898041, -124.94735270596453, 22.31826282586826, 425.50086780334868, 303.6227182371648, -325.60433188341756, 369.07533352872144);
            double4x4 b3 = double4x4(-405.94388050862767, -347.05557386346891, -72.926237378700762, -137.94250995383715, 403.42982716273048, 501.53929423798775, -55.528008725274333, 225.85078178432343, -57.186008718417042, -185.23014577907981, -481.59480188861249, 319.05534735278013, 337.43364421344995, -481.09287689677109, 223.93316017088159, 174.32254107963411);
            bool4x4 r3 = bool4x4(true, true, true, false, false, false, true, true, false, true, true, false, true, true, false, true);
            TestUtils.AreEqual(a3 >= b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_greater_equal_wide_scalar()
        {
            double4x4 a0 = double4x4(495.457423679278, -14.345115906719627, -463.47478053694346, 217.51749215718246, -246.86571776441565, -377.65869706573835, 53.815095211293169, -123.33294373533357, -221.50546441856096, 252.99433410027734, -116.44038277326172, -395.36331028275345, 164.77259667439978, -287.00733889593153, 355.83704559683667, 184.19556316369938);
            double b0 = (189.20512804258851);
            bool4x4 r0 = bool4x4(true, false, false, true, false, false, false, false, false, true, false, false, false, false, true, false);
            TestUtils.AreEqual(a0 >= b0, r0);

            double4x4 a1 = double4x4(273.01225555735277, 249.38409697701411, 396.39213938098032, 332.66542044871744, 243.76141392614761, -335.121477998384, -302.08690442800844, 254.44223344253476, 179.00504287472234, 71.176674637560154, -331.27167788672807, 307.89058008226129, -388.57851737950858, 150.60576422075076, -219.89257989632551, -491.68100213058341);
            double b1 = (-418.14240308205706);
            bool4x4 r1 = bool4x4(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false);
            TestUtils.AreEqual(a1 >= b1, r1);

            double4x4 a2 = double4x4(30.997067704329766, -74.50001743924804, -343.38647357718389, 216.0315855555383, -420.40314813163275, -78.384021080277876, -336.6411160606151, 317.0945958183587, -262.42494666875569, -228.41125522759336, 123.46545964268296, 264.10247362037308, 223.62332569045168, 440.53538366804617, -420.72700830024064, 74.844301497025526);
            double b2 = (199.23222861030706);
            bool4x4 r2 = bool4x4(false, false, false, true, false, false, false, true, false, false, false, true, true, true, false, false);
            TestUtils.AreEqual(a2 >= b2, r2);

            double4x4 a3 = double4x4(-177.07789405485516, -28.596381439173797, 165.28756173201259, -349.20799676943943, 457.4437141164409, -191.2236379083356, 350.61212389106493, 475.07525871464759, 86.129239360862016, 63.164628296701494, -126.91322690197882, 80.776476182405077, -344.92694703905238, -409.61143012047347, -408.5478028769362, -415.68230815217009);
            double b3 = (482.71023033685526);
            bool4x4 r3 = bool4x4(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
            TestUtils.AreEqual(a3 >= b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_greater_equal_scalar_wide()
        {
            double a0 = (215.43534169692327);
            double4x4 b0 = double4x4(204.80295310020585, -101.10404853760451, -122.05503827056617, -70.456147941973143, -239.62025677395064, -185.99272426683115, -455.61258027312, 276.66581476697036, 79.39918831707871, 416.42054791768112, 379.27350801009379, -439.51472612820322, 67.141009600433108, -74.560638224035813, -367.25635474140586, 494.950765601802);
            bool4x4 r0 = bool4x4(true, true, true, true, true, true, true, false, true, false, false, true, true, true, true, false);
            TestUtils.AreEqual(a0 >= b0, r0);

            double a1 = (-61.235545425319856);
            double4x4 b1 = double4x4(-429.17024846988278, -213.82468924942646, -264.31016242891093, 243.11378275748052, -22.383876095704693, 304.86197175870745, -323.68615332417477, 67.938025267765852, 125.30356818312009, -400.47050280145857, -283.15963162256389, -42.319595595039232, -429.51037355396448, 499.3958854616601, -289.96307887228352, -136.00878554955534);
            bool4x4 r1 = bool4x4(true, true, true, false, false, false, true, false, false, true, true, false, true, false, true, true);
            TestUtils.AreEqual(a1 >= b1, r1);

            double a2 = (-351.12526123184955);
            double4x4 b2 = double4x4(-381.81828921931719, 393.30091089443351, 18.023639925766588, -169.92393048569744, -285.88492669066648, 163.75110037799516, 191.85533317916804, 114.01553230826539, -395.98584169707533, 189.3665684151307, 176.19814618686132, 61.713796405919766, 507.54848241598745, 224.04381595554003, -422.99370570806491, -127.05500394061909);
            bool4x4 r2 = bool4x4(true, false, false, false, false, false, false, false, true, false, false, false, false, false, true, false);
            TestUtils.AreEqual(a2 >= b2, r2);

            double a3 = (95.528642460484321);
            double4x4 b3 = double4x4(362.56816761687776, -501.04042148079742, 314.66822471966418, 484.32155893944275, -284.81317080408951, 106.03397970368803, -310.3688849463914, 373.60582679026095, 147.07617504292921, -297.52222146537258, 339.5470513494439, -193.01458963799041, -3.090438128956805, 429.024662456021, 157.23658688237731, 208.49405942135218);
            bool4x4 r3 = bool4x4(false, true, false, false, true, false, true, false, false, true, false, true, true, false, false, false);
            TestUtils.AreEqual(a3 >= b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_add_wide_wide()
        {
            double4x4 a0 = double4x4(465.14837644302679, 278.91072548502621, -277.52992237616792, -65.197214395365336, -473.32437561141529, -4.6955420992782138, -470.53676698661258, -109.95011453980118, -178.70145782209067, -420.03378339299644, 290.71109236903078, -446.5296368294068, 491.066454400805, -261.11730039358014, -298.40688409395835, 502.42861890347149);
            double4x4 b0 = double4x4(483.99436186440028, -204.07667193379098, -365.67356007437854, -509.92086076639634, -270.69751108377125, 486.76397846954126, 267.49177587567442, 251.6425212601398, 244.4951094335388, -78.675763882079991, 352.20551340291536, 82.779185095233515, 462.54732606492348, -405.492017696375, -428.4983238785054, -41.872599859662614);
            double4x4 r0 = double4x4(949.14273830742707, 74.834053551235229, -643.20348245054652, -575.11807516176168, -744.02188669518659, 482.06843637026304, -203.04499111093816, 141.69240672033862, 65.793651611448126, -498.70954727507643, 642.91660577194614, -363.75045173417328, 953.6137804657285, -666.6093180899552, -726.90520797246381, 460.55601904380887);
            TestUtils.AreEqual(a0 + b0, r0);

            double4x4 a1 = double4x4(284.59432925125316, 401.12844366632794, -36.263498084742366, -102.94915657069026, 503.19817161150195, -384.42911857386542, -45.22821452339565, -198.67394337368847, -62.8800013358146, -79.55225447544467, 413.0982751385767, -100.87757997441923, 418.523998693807, -183.143126334596, 407.44374031920165, 300.48602332756207);
            double4x4 b1 = double4x4(-269.9274958436971, 75.204465662690041, -141.91339380196922, -222.1867559990784, 41.305726308983594, 148.33947117083676, -177.23311217931712, -176.51887830370987, 492.69246768052335, 439.04383942067807, -511.74275922763292, -399.05713695988857, -315.8684596102072, -228.0772484410914, -171.70519669899028, 467.17394826709005);
            double4x4 r1 = double4x4(14.666833407556055, 476.332909329018, -178.17689188671159, -325.13591256976866, 544.50389792048554, -236.08964740302866, -222.46132670271277, -375.19282167739834, 429.81246634470875, 359.4915849452334, -98.64448408905622, -499.9347169343078, 102.65553908359982, -411.22037477568739, 235.73854362021137, 767.65997159465212);
            TestUtils.AreEqual(a1 + b1, r1);

            double4x4 a2 = double4x4(-261.12612998724273, -309.8303507817119, 378.36333220934648, -224.09398065511789, -164.55573399577094, -69.873935493581882, 224.63463197678072, -383.99260038137095, 149.2212694386119, 169.38798363943954, 163.05393059693927, 57.02912500176069, 342.95008413072219, 168.68046696888302, -470.77026746737317, -117.63049631828);
            double4x4 b2 = double4x4(-474.8229422396156, 311.39072885708447, 326.84541979750873, 475.21193597987849, 314.152972606082, -262.59463393995287, -82.869108000243614, 156.29956658012213, 427.40157791012973, -279.09935177448176, -448.61522051720658, 284.33708847888613, 288.18558062621651, -232.39503847453511, -386.87190812959892, 162.90336831049217);
            double4x4 r2 = double4x4(-735.94907222685833, 1.5603780753725687, 705.20875200685521, 251.1179553247606, 149.59723861031108, -332.46856943353475, 141.76552397653711, -227.69303380124882, 576.62284734874163, -109.71136813504222, -285.56128992026731, 341.36621348064682, 631.1356647569387, -63.714571505652088, -857.642175596972, 45.272871992212174);
            TestUtils.AreEqual(a2 + b2, r2);

            double4x4 a3 = double4x4(252.81970298142164, -102.53439884192051, -379.40276139760522, -42.88221051305635, 204.78644833564124, 91.599573416448948, 70.131176265948966, -111.69176893666935, -443.8758592288363, 134.70148212029665, 170.90681966157013, -207.87998232984916, -19.85206724137629, 480.44064472636239, -353.8350471713743, 433.98220344725166);
            double4x4 b3 = double4x4(-339.60306684095553, -82.40527228378005, 1.9353277692270012, 122.27457886667673, -42.76419045532316, -413.05469746750532, -350.28294603446636, -10.60689330594937, 172.55730708528188, 492.04216240907192, 67.585375102043827, -324.51090947003615, -82.16743926059803, -421.82224841687, -503.69894218058278, -289.683825866172);
            double4x4 r3 = double4x4(-86.783363859533893, -184.93967112570056, -377.46743362837822, 79.392368353620384, 162.02225788031808, -321.45512405105637, -280.1517697685174, -122.29866224261872, -271.31855214355443, 626.74364452936857, 238.49219476361395, -532.39089179988537, -102.01950650197432, 58.618396309492368, -857.53398935195708, 144.29837758107965);
            TestUtils.AreEqual(a3 + b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_add_wide_scalar()
        {
            double4x4 a0 = double4x4(459.89829728561369, -447.66336104258119, -94.438627525436971, 126.42986279652916, -36.254356162741033, -349.64130060264904, -2.7912590516690443, -478.41478489265535, 443.11525246273504, 268.092225914864, 41.32102133767728, -471.25607584009697, -2.6649749291431704, 78.985822952811532, 202.14799151297098, 311.7254551908585);
            double b0 = (500.99725913489112);
            double4x4 r0 = double4x4(960.89555642050482, 53.333898092309937, 406.55863160945415, 627.42712193142029, 464.74290297215009, 151.35595853224208, 498.20600008322208, 22.582474242235776, 944.11251159762617, 769.08948504975513, 542.3182804725684, 29.741183294794155, 498.33228420574795, 579.98308208770266, 703.1452506478621, 812.72271432574962);
            TestUtils.AreEqual(a0 + b0, r0);

            double4x4 a1 = double4x4(10.345855002452595, 355.23276703210206, -197.80076584490052, 255.95526587961024, 244.14709793969394, -181.6265695940827, -2.4549267303454485, 300.90065469448484, -236.49194895312746, -160.5840962680914, -172.54221566605486, -242.9410861669765, 466.34409902353957, 237.98745810146795, 264.294014815378, 372.86684029775995);
            double b1 = (-151.24445898423181);
            double4x4 r1 = double4x4(-140.89860398177922, 203.98830804787025, -349.04522482913234, 104.71080689537843, 92.902638955462123, -332.87102857831451, -153.69938571457726, 149.65619571025303, -387.73640793735927, -311.82855525232321, -323.78667465028667, -394.18554515120832, 315.09964003930776, 86.742999117236138, 113.04955583114617, 221.62238131352814);
            TestUtils.AreEqual(a1 + b1, r1);

            double4x4 a2 = double4x4(-198.83777699192882, 402.16034693371523, -117.02482729639149, 497.37375592504338, 485.90928124166521, -47.757128976172339, 77.81479338454767, -271.54797304400614, -133.25178605562627, 211.86678777070097, 253.15022504196975, -342.78316823708974, -185.24833997769667, -403.38548845955427, -358.84824125787628, 65.247578889712486);
            double b2 = (-381.930974899759);
            double4x4 r2 = double4x4(-580.76875189168777, 20.229372033956224, -498.9558021961505, 115.44278102528438, 103.9783063419062, -429.68810387593135, -304.11618151521134, -653.47894794376521, -515.18276095538522, -170.06418712905804, -128.78074985778926, -724.71414313684875, -567.17931487745568, -785.31646335931327, -740.77921615763535, -316.68339601004652);
            TestUtils.AreEqual(a2 + b2, r2);

            double4x4 a3 = double4x4(127.2016943093397, 432.12115903949416, 436.08892055791284, -308.05696859399643, -255.14983880480276, 245.96320855150145, 420.01629920490848, 337.52920810204432, -311.76240720961357, 322.94279566544242, -342.24904338561419, 276.52630127432121, 488.77115343919547, -481.89523218660395, 289.0270065222993, -332.12291613785686);
            double b3 = (-112.13987141109067);
            double4x4 r3 = double4x4(15.061822898249034, 319.98128762840349, 323.94904914682218, -420.1968400050871, -367.28971021589342, 133.82333714041079, 307.87642779381781, 225.38933669095366, -423.90227862070424, 210.80292425435175, -454.38891479670485, 164.38642986323055, 376.63128202810481, -594.03510359769462, 176.88713511120864, -444.26278754894753);
            TestUtils.AreEqual(a3 + b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_add_scalar_wide()
        {
            double a0 = (-325.51276484388518);
            double4x4 b0 = double4x4(-264.08813178915909, -106.00925998855814, -355.44729320865463, -447.33029362528134, -158.70021040677102, -199.48369154682553, 180.31809123806568, 337.57936898692481, -37.05501486596421, 230.80498014707348, -140.17433339924287, 18.02419591789328, -138.61435825126915, 26.904163611542458, -374.53758233345, 154.4676006559597);
            double4x4 r0 = double4x4(-589.60089663304427, -431.52202483244332, -680.96005805253981, -772.84305846916652, -484.2129752506562, -524.9964563907107, -145.1946736058195, 12.066604143039626, -362.56777970984939, -94.7077846968117, -465.68709824312805, -307.4885689259919, -464.12712309515433, -298.60860123234272, -700.0503471773352, -171.04516418792548);
            TestUtils.AreEqual(a0 + b0, r0);

            double a1 = (268.3838204203098);
            double4x4 b1 = double4x4(-190.96302255939833, 188.61725362977813, -504.91612386373623, 20.454013595568995, 197.94534525552081, 251.41194474483461, -421.09037538109828, 111.44540052835146, -73.268883024001923, 480.88455770950975, 438.05301233662897, 66.844289095534123, -270.79599941465818, -44.02192189359198, 197.69471916821544, 19.113929995854392);
            double4x4 r1 = double4x4(77.420797860911478, 457.00107405008794, -236.53230344342643, 288.8378340158788, 466.32916567583061, 519.79576516514442, -152.70655496078848, 379.82922094866126, 195.11493739630788, 749.26837812981955, 706.43683275693877, 335.22810951584393, -2.4121789943483805, 224.36189852671782, 466.07853958852525, 287.49775041616419);
            TestUtils.AreEqual(a1 + b1, r1);

            double a2 = (349.23776857426287);
            double4x4 b2 = double4x4(366.23449271090067, -413.48026890935387, -260.720191361718, 77.542334831106587, 183.95489009840173, -51.498981738229759, -472.4974751288525, 107.12689285498436, 349.07720033688338, 431.59597774576207, -314.11096468293618, 396.99665302643393, -167.30862935227742, -157.11451895400626, 287.76251591730977, -367.33903544365387);
            double4x4 r2 = double4x4(715.47226128516354, -64.242500335091, 88.5175772125449, 426.78010340536946, 533.19265867266461, 297.73878683603311, -123.25970655458963, 456.36466142924723, 698.31496891114625, 780.83374632002494, 35.126803891326688, 746.23442160069681, 181.92913922198545, 192.12324962025662, 637.00028449157264, -18.101266869390997);
            TestUtils.AreEqual(a2 + b2, r2);

            double a3 = (96.2368000001818);
            double4x4 b3 = double4x4(212.02315984108634, -400.69347614827262, 26.342837584364588, 166.03322156054583, 49.9665229553201, 154.57879526660724, -446.35691782755634, -46.7756941536328, 426.56867261723085, -168.36824925633533, 254.26507890143671, -241.26492010860932, -278.259015451306, -237.17309795933454, 174.13094743254169, 510.91026592203889);
            double4x4 r3 = double4x4(308.25995984126814, -304.45667614809082, 122.57963758454639, 262.27002156072763, 146.2033229555019, 250.81559526678905, -350.12011782737454, 49.461105846549, 522.80547261741265, -72.13144925615353, 350.50187890161851, -145.02812010842752, -182.02221545112423, -140.93629795915274, 270.36774743272349, 607.14706592222069);
            TestUtils.AreEqual(a3 + b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_sub_wide_wide()
        {
            double4x4 a0 = double4x4(133.37101680290471, -131.8321183341705, -197.29314407952739, -485.286571013409, -337.55033103448818, 471.66710470228782, 146.5066197600712, -130.58504372955537, 110.77707367333448, -235.54160486699158, 78.879356659427, -347.68616811730254, -470.82054565419469, -11.459293609233271, -167.94791730118351, 330.67676917215658);
            double4x4 b0 = double4x4(123.46028739002543, 359.56010048443454, -48.24847819667707, 478.97904680621764, 207.15832886805686, 142.36730462981723, -125.60551005490379, -65.299004823574307, -477.876434787119, 164.50000031501986, 428.00958915614035, 72.6278169493321, -446.880505531505, 432.09146114443035, -225.55465637219822, -112.45196705332586);
            double4x4 r0 = double4x4(9.9107294128792773, -491.39221881860504, -149.04466588285032, -964.26561781962664, -544.708659902545, 329.29980007247059, 272.112129814975, -65.286038905981059, 588.65350846045351, -400.04160518201144, -349.13023249671335, -420.31398506663464, -23.940040122689709, -443.55075475366363, 57.606739071014715, 443.12873622548244);
            TestUtils.AreEqual(a0 - b0, r0);

            double4x4 a1 = double4x4(-508.35086822339838, -252.03190457636111, -427.93418737311578, 192.6576150360786, 168.42931016182024, 457.3087858899072, 470.05851457550125, -299.71188058504458, -308.93956937870922, 454.53341052240387, 26.106923830745245, -482.71181105203544, -40.853544492671972, 318.38064613862923, 475.21081541255614, 134.9269641074012);
            double4x4 b1 = double4x4(-210.61278853687122, -172.92506011432272, -80.60749415336528, 270.04610861001822, -154.25558550388348, 148.47577745675846, 13.661130673094249, 70.671096596248049, -221.32544551665217, -9.2588145775994235, 288.1738385111903, 217.36142764676424, 307.54006471649745, -262.41263854802241, -405.3780321578393, 400.00432533771004);
            double4x4 r1 = double4x4(-297.73807968652716, -79.1068444620384, -347.3266932197505, -77.388493573939627, 322.68489566570372, 308.83300843314873, 456.397383902407, -370.38297718129263, -87.614123862057056, 463.79222510000329, -262.06691468044505, -700.07323869879974, -348.39360920916943, 580.79328468665165, 880.5888475703955, -265.07736123030884);
            TestUtils.AreEqual(a1 - b1, r1);

            double4x4 a2 = double4x4(388.48155969590016, 138.71817285321572, -385.57360547854267, -149.36481745045859, -158.53404982319756, 508.07069015319962, 482.70080326623315, 114.56930237383085, 364.83137505353955, 229.03103052313952, -168.08806689460204, 373.44110911592895, -239.90097748483578, 379.92848437834925, 113.01185970800555, 306.83529319746197);
            double4x4 b2 = double4x4(72.119071755613732, -154.88059170305758, -469.65998361523265, -320.61543217330029, 6.4122865229902573, -278.86505783668952, 15.838054425939049, 27.518323672711062, 429.86960979451874, -458.62247178453134, -172.064416250244, -284.52470673458868, 42.606667776874588, -223.47425208961323, -56.92974641589899, 61.8073423196596);
            double4x4 r2 = double4x4(316.36248794028643, 293.5987645562733, 84.086378136689973, 171.2506147228417, -164.94633634618782, 786.93574798988914, 466.8627488402941, 87.050978701119789, -65.038234740979192, 687.65350230767081, 3.9763493556419576, 657.96581585051763, -282.50764526171037, 603.40273646796254, 169.94160612390453, 245.02795087780237);
            TestUtils.AreEqual(a2 - b2, r2);

            double4x4 a3 = double4x4(222.81745038871532, 271.99421776085819, 386.94295781987853, -55.755297925209277, 440.03937193380636, -362.72476475440192, 292.10314835799068, 246.66062438053109, -319.0292376573334, -115.24401360156202, -122.40906268097882, 56.092392232312022, 210.67796263968478, -426.9796142182218, -337.58846799358184, 78.372708118694277);
            double4x4 b3 = double4x4(-454.69553944780284, -114.06055718011248, 367.168711118013, -351.27958576347658, 263.14884269570416, -492.305362692245, 308.15324678465413, 455.308401081389, -221.13767753408183, -466.65879438196254, 81.54943589193249, 48.545975946144154, -88.7571204121956, 83.8197267445828, -437.89056536084536, 410.39569659270148);
            double4x4 r3 = double4x4(677.51298983651816, 386.05477494097067, 19.774246701865536, 295.5242878382673, 176.8905292381022, 129.58059793784309, -16.050098426663453, -208.64777670085789, -97.891560123251566, 351.41478078040052, -203.95849857291131, 7.5464162861678687, 299.43508305188038, -510.79934096280459, 100.30209736726351, -332.02298847400721);
            TestUtils.AreEqual(a3 - b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_sub_wide_scalar()
        {
            double4x4 a0 = double4x4(48.936717294592768, 410.45158953706346, -364.44171612544062, 163.98060353285666, -460.06732318367222, 110.91942339340198, 204.35834441164434, 180.26971420099483, -377.92569344952972, -470.26204297983185, 400.53491968686455, 461.50756499800252, -246.28726660753006, 21.605312595891405, 246.35072171238755, -121.42736178330489);
            double b0 = (-291.59041442144212);
            double4x4 r0 = double4x4(340.52713171603489, 702.04200395850557, -72.8513017039985, 455.57101795429878, -168.4769087622301, 402.5098378148441, 495.94875883308646, 471.86012862243695, -86.3352790280876, -178.67162855838973, 692.12533410830667, 753.09797941944464, 45.303147813912062, 313.19572701733352, 537.94113613382967, 170.16305263813723);
            TestUtils.AreEqual(a0 - b0, r0);

            double4x4 a1 = double4x4(-122.71842413894757, 360.15095417581074, 342.87457887403411, 18.929827460520869, 164.60235245740148, 97.0436885808798, 485.9149813530571, -205.75765690848124, 253.44322717070725, -121.16305619159857, 187.99838813953022, -450.820273370864, -248.07337128746946, -26.996065390760123, 441.55261942444031, 449.91060969322484);
            double b1 = (-122.93872099879138);
            double4x4 r1 = double4x4(0.22029685984381331, 483.08967517460212, 465.8132998728255, 141.86854845931225, 287.54107345619286, 219.98240957967118, 608.85370235184848, -82.818935909689856, 376.38194816949863, 1.7756648071928112, 310.9371091383216, -327.88155237207263, -125.13465028867807, 95.942655608031259, 564.49134042323169, 572.84933069201622);
            TestUtils.AreEqual(a1 - b1, r1);

            double4x4 a2 = double4x4(354.88602678612153, -189.19323381650878, 269.07481659067548, -59.118566302172155, 363.45839207407948, -73.779217515969265, -46.155220768486743, 109.9132454907118, 182.64693483274755, 229.01577411825576, -144.92867405010793, 469.25061414635309, -150.49230797146089, -192.31251177206286, -224.35684810595438, 285.87681855162452);
            double b2 = (98.821485803845121);
            double4x4 r2 = double4x4(256.06454098227641, -288.0147196203539, 170.25333078683036, -157.94005210601728, 264.63690627023436, -172.60070331981439, -144.97670657233186, 11.091759686866681, 83.825449028902426, 130.19428831441064, -243.75015985395305, 370.42912834250797, -249.313793775306, -291.133997575908, -323.17833390979951, 187.0553327477794);
            TestUtils.AreEqual(a2 - b2, r2);

            double4x4 a3 = double4x4(-63.010835438506149, 152.83310110533284, 92.32092456348289, -481.9931101659281, 55.807233121156287, -198.59209904381635, -338.35669747849772, -142.26173955866216, -201.51055035437946, -279.91752041499944, -495.64004372788594, 119.08998757185884, 382.1476778379398, 68.734022410928333, 470.98230026242436, -500.40304469522232);
            double b3 = (499.91121673021053);
            double4x4 r3 = double4x4(-562.92205216871662, -347.07811562487768, -407.59029216672764, -981.90432689613863, -444.10398360905424, -698.50331577402687, -838.26791420870825, -642.17295628887268, -701.42176708459, -779.82873714521, -995.55126045809652, -380.82122915835168, -117.76353889227073, -431.17719431928219, -28.928916467786166, -1000.3142614254328);
            TestUtils.AreEqual(a3 - b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_sub_scalar_wide()
        {
            double a0 = (294.58645905861);
            double4x4 b0 = double4x4(452.35251757705237, 256.98980891750648, -275.159888634067, -89.027518075437968, 488.22838829840919, -333.21728030462623, -64.232989102710519, -66.041730196234653, 341.20492831859963, -385.775056303374, 75.394746577085357, 354.94371645289641, 169.13141520746581, 88.216608326982964, 1.7350065716240124, 122.53803997977548);
            double4x4 r0 = double4x4(-157.76605851844238, 37.59665014110351, 569.746347692677, 383.61397713404796, -193.6419292397992, 627.80373936323622, 358.81944816132051, 360.62818925484464, -46.618469259989638, 680.361515361984, 219.19171248152463, -60.357257394286421, 125.45504385114418, 206.36985073162703, 292.851452486986, 172.04841907883451);
            TestUtils.AreEqual(a0 - b0, r0);

            double a1 = (-264.94502771317264);
            double4x4 b1 = double4x4(-50.837180399725753, -347.65032283759228, 4.0655586738445209, -79.095424450512724, 354.35833923628479, -292.4925116470514, -53.208983207684469, -246.34760033634848, 299.20334138497867, 432.18467422583353, -163.88000090600923, 176.74255546216978, -104.9858415615679, -445.7976302792307, -28.873155368898608, -169.58822901993443);
            double4x4 r1 = double4x4(-214.10784731344688, 82.705295124419649, -269.01058638701716, -185.84960326265991, -619.30336694945743, 27.547483933878766, -211.73604450548817, -18.597427376824157, -564.14836909815131, -697.12970193900617, -101.06502680716341, -441.68758317534241, -159.95918615160474, 180.85260256605807, -236.07187234427403, -95.3567986932382);
            TestUtils.AreEqual(a1 - b1, r1);

            double a2 = (-270.35924614144454);
            double4x4 b2 = double4x4(68.0476272423042, -65.531290323255234, 440.38039776328037, 427.36063142649857, -81.472953595906915, 41.713177461974851, 175.82078059754372, -214.94915900703018, -163.44686253529363, -218.82914672551169, 389.1168579483018, -74.109779154001615, -448.13723751908969, -410.37498278653948, 363.21098177657041, -263.53538120143833);
            double4x4 r2 = double4x4(-338.40687338374875, -204.82795581818931, -710.739643904725, -697.71987756794306, -188.88629254553763, -312.0724236034194, -446.18002673898826, -55.410087134414368, -106.91238360615091, -51.530099415932852, -659.47610408974629, -196.24946698744293, 177.77799137764515, 140.01573664509493, -633.570227918015, -6.8238649400062172);
            TestUtils.AreEqual(a2 - b2, r2);

            double a3 = (473.54599283335074);
            double4x4 b3 = double4x4(433.433287583959, 241.46943842688086, -446.75619074644345, -138.31811649087729, -414.00582165923242, 37.482320564557995, 290.04909457361748, -354.67991773908955, -322.97495308656943, -253.40195453045982, -412.35298819670129, 269.21571434159569, -65.809230119832421, -451.97742602414331, -407.73209805401603, 12.531945472830898);
            double4x4 r3 = double4x4(40.112705249391752, 232.07655440646988, 920.30218357979425, 611.864109324228, 887.55181449258316, 436.06367226879274, 183.49689825973326, 828.22591057244028, 796.52094591992022, 726.9479473638105, 885.898981030052, 204.33027849175505, 539.3552229531831, 925.52341885749411, 881.27809088736672, 461.01404736051984);
            TestUtils.AreEqual(a3 - b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_mul_wide_wide()
        {
            double4x4 a0 = double4x4(-394.78053898121254, -412.37219519744264, -25.874570143350638, -241.04595886964626, -93.675987525692221, 244.15999257013198, 494.68846606402121, 53.537962700025105, -239.49641167349017, 236.67584644848284, -211.85620818466703, -216.65482030466887, 467.95832870339893, -178.02191146557311, -386.3942503344241, -422.43540521265726);
            double4x4 b0 = double4x4(-149.76397831261346, -345.04538671348496, -284.33404721148963, 267.97923648915219, -326.64849558782225, -150.68967754705329, 207.73243794577775, 366.19289248352538, 358.88076202891807, 214.85359368792433, 253.42280900358355, -307.71382751488773, 184.4711149597872, 426.43644185850235, -144.28142625851621, 459.47961518703016);
            double4x4 r0 = double4x4(59123.904078224172, 142287.1235617903, 7357.0212487164608, -64595.312016683383, 30599.120397970968, -36792.390550284115, 102762.84107913627, 19605.221418797286, -85950.654724573629, 50850.6561485879, -53689.195383006307, 66667.684005499876, 86324.794650634591, -75915.030498228327, 55749.513536340863, -194100.45742848891);
            TestUtils.AreEqual(a0 * b0, r0);

            double4x4 a1 = double4x4(464.58952758488692, -251.3156646468284, -104.97877912641445, -66.934159071619717, -39.829896707008572, 401.56559080703448, 434.14618250082538, -336.45419589451245, -83.11415318544681, 329.96027842627848, -316.97214594342381, 474.9379296130212, -445.10915800794453, -301.00371541688389, 405.68786425408337, 142.37348682357629);
            double4x4 b1 = double4x4(-358.31334917541284, -201.36521563370025, 254.90996539541982, 168.52096303204121, 8.7945530455533572, -194.84647974504458, -405.36266178887462, -180.7321890242082, -189.74690946831691, -35.518455760329232, 120.31664210200154, -136.2033479847961, 407.34163231744503, 301.65431489686216, -155.4824007281486, -461.39456126717596);
            double4x4 r1 = double4x4(-166468.62962076368, 50606.233003735295, -26760.136954367728, -11279.808946489193, -350.28613938869785, -78243.6417554897, -175986.65214401312, 60808.103330394995, 15770.6537000148, -11719.679551949688, -38137.024239778322, -64688.136098260919, -181311.49098239967, -90799.069555490176, -63077.323080500144, -65690.352489042038);
            TestUtils.AreEqual(a1 * b1, r1);

            double4x4 a2 = double4x4(-416.21309037516505, -103.27920513194016, -52.951897407393858, -40.828328390060165, -86.185078899462269, -257.3165096050671, 363.85721819654907, -229.86001001571304, 8.925310854299596, -2.4494049560508984, 37.75829531520526, 264.45176113045386, -321.251278788434, -268.25605762575572, 43.91368081230371, 274.83309877795773);
            double4x4 b2 = double4x4(296.68037738310193, 341.001815239434, -257.09682166627459, 17.593622931089953, -443.84511658355831, 291.3492387697795, 490.1916594403757, 361.32099049227361, -509.28972244136486, 315.35265913389276, 125.08305054767197, -167.72711451711467, 396.8876833379677, -0.32041144385954112, 143.41152603151818, -396.34749597885997);
            double4x4 r2 = double4x4(-123482.25672429107, -35218.396426477462, 13613.764524639606, -718.31821460143351, 38252.826391895, -74968.969196332953, 178359.77358712527, -83053.246493441373, -4545.5690876891422, -772.42636618638653, 4722.9227615057453, -44355.730823380291, -127500.67580770116, 85.95231074793665, 6297.7279789534741, -108929.41051275423);
            TestUtils.AreEqual(a2 * b2, r2);

            double4x4 a3 = double4x4(378.42106622197718, -290.63338936987952, 209.91654334306554, 384.21970838318566, 363.08141892174319, -461.33337686086696, -134.36684829293137, 11.939433818654834, 125.20164233315813, -219.27099595743744, 358.96700422790229, 12.847143417618781, -479.771383747352, 150.25309402786809, -500.84076404051893, 485.67994211878624);
            double4x4 b3 = double4x4(350.96015207421044, -374.53419488227655, -165.4560111339465, -338.01733151917222, -199.63334450481148, -385.12702935986545, -328.41130915675842, -423.30081744832023, -150.3247059091575, 402.97758669544828, 339.02082768968341, -29.296140922837026, -447.55209061482554, 62.160419254638441, 471.49208305379943, 282.40339506901955);
            double4x4 r3 = double4x4(132810.71494934996, 108852.14249355502, -34731.953932569813, -129872.92054475893, -72483.157986900129, 177671.952974981, 44127.592555149138, -5053.9720953067108, -18820.900063075522, -88361.296783235535, 121697.29088662952, -376.37172401845788, 214722.68581329513, 9339.7953190788921, -236142.45511572072, 137157.66457127014);
            TestUtils.AreEqual(a3 * b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_mul_wide_scalar()
        {
            double4x4 a0 = double4x4(328.20302191758674, -290.10672272839895, 236.99572454998065, 120.48136692889102, 357.90315811610924, 134.86723214707672, -477.31047104173825, -438.272912467957, -46.729179165665585, -238.40500103608008, 422.08249374017237, -48.83483722099794, 355.30832998608628, 119.35660391643489, -196.995807977857, 98.2360046367329);
            double b0 = (192.21119055161773);
            double4x4 r0 = double4x4(63084.293585418032, -55761.758562653624, 45553.230371395039, 23157.866976688449, 68792.992123681237, 25922.99125739103, -91744.41390168597, -84240.958291990959, -8981.8711609324328, -45824.109082604613, 81128.978632794271, -9386.6022026424689, 68294.2371195327, 22941.67493897583, -37864.798785101768, 18882.059406260672);
            TestUtils.AreEqual(a0 * b0, r0);

            double4x4 a1 = double4x4(-325.55215683837991, -87.4509838034636, -130.47412949915702, -222.59457145565869, 126.01503211167415, 293.36108769726059, 174.38195737375963, -327.12007704708731, 56.629123475695565, 257.54154241156834, -475.60871551726422, -452.69189450363251, -49.220605157884108, 141.60094959177115, 431.58568330834885, 180.35518583113105);
            double b1 = (53.937323833786536);
            double4x4 r1 = double4x4(-17559.41210817936, -4716.8720329906373, -7037.4253747274324, -12006.1554842468, 6796.9135949323772, 15823.111987358996, 9405.6961056380333, -17643.98152822195, 3054.423371332075, 13891.101573705631, -25653.061307025935, -24416.989310772758, -2654.8277196957392, 7637.5762733030442, 23278.576762628451, 9727.8760632764643);
            TestUtils.AreEqual(a1 * b1, r1);

            double4x4 a2 = double4x4(-40.92345454214302, 120.01444226131514, -59.508660105759589, 319.48987236595246, -403.52316040709763, -408.19309849673562, -335.39319554688092, -364.24254601273805, 150.68615085942952, 391.87204212316874, 179.3124121070432, 354.52978460608506, 497.76140164665946, 418.43656964713546, -413.33335967237753, -329.5207184895504);
            double b2 = (279.54350842141707);
            double4x4 r2 = double4x4(-11439.886059435035, 33549.258250967621, -16635.259627421652, 89311.3198262891, -112802.27998949833, -114107.73086718655, -93756.990583845487, -101821.63922875024, 42123.335281763859, 109545.28550737593, 50125.620783909842, 99106.499828674321, 139145.96857306932, 116971.22673098287, -115544.65751042787, -92115.377744115045);
            TestUtils.AreEqual(a2 * b2, r2);

            double4x4 a3 = double4x4(-322.70306339985837, -344.13115159800793, 209.61276135668754, 38.797593373245377, -445.80384156005636, -71.467810425659536, -449.386232823779, -64.39855602402173, -210.72596535958627, 389.32568973550838, 510.29824447552596, -497.58101796432447, -509.50857400778148, 131.99404937214877, 502.49681043182352, 282.80997694787106);
            double b3 = (-285.63120783755147);
            double4x4 r3 = double4x4(92174.0657717795, 98294.596485466536, -59871.9462044751, -11081.80345639026, 127335.48972341932, 20413.437013386287, 128358.7324670231, 18394.237340135554, 60189.912008392661, -111203.56700134107, -145757.10392692662, 142124.66715818839, 145531.54939743111, -37701.619749536258, -143528.77089815889, -80779.3553041305);
            TestUtils.AreEqual(a3 * b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_mul_scalar_wide()
        {
            double a0 = (-464.534700371574);
            double4x4 b0 = double4x4(329.36093846399376, -198.68342671109525, 184.07942518223047, 256.01618754864489, 266.22629297255833, -97.894749448585685, 159.74810583877752, -351.82222263506719, 491.80157660497423, 49.902031206480274, 424.46256871915546, 160.11807616060514, -395.99208492599058, 125.20168858636248, -265.01581991138676, 314.65609779705107);
            double4x4 r0 = double4x4(-152999.58486347177, 92295.346096036214, -85511.280621599, -118928.40297318244, -123671.35123704225, 45475.508103049062, -74208.538480743009, 163433.63077584215, -228458.89803045939, -23181.225114435249, -197177.59217890151, -74380.402533339569, 183952.06452060991, -58160.528893481009, 123109.04449626306, -146168.67611024179);
            TestUtils.AreEqual(a0 * b0, r0);

            double a1 = (-292.71202029507236);
            double4x4 b1 = double4x4(-37.729878681586058, 165.3622206027444, 356.51773302467438, -188.81332906932261, 504.91572475103465, 40.572113771257932, -206.77510581108515, -61.602680473403382, 118.97158938225903, 53.7483275186961, -198.66941771221786, 96.23611287783649, -20.241880664714529, -31.123976006696012, 38.890465516080326, -13.133307701504464);
            double4x4 r1 = double4x4(11043.989014375036, -48403.509673108754, -104357.02590467168, 55267.931010519736, -147794.90187062602, -11875.945389626437, 60525.558968690093, 18031.845056961709, -34824.414285796818, -15732.781535478769, 58152.926629388923, -28169.46702581615, 5925.0417839403517, 9110.3618965353489, -11383.706731427716, 3844.2770304642049);
            TestUtils.AreEqual(a1 * b1, r1);

            double a2 = (507.87128209875493);
            double4x4 b2 = double4x4(95.017933651347562, 340.74862186086762, 438.98690172610191, -227.16596637813655, 452.57297894571582, 144.01496774703958, -31.586035981581574, 42.297746916440246, -466.02715013270597, 287.454008951529, 328.99688378395365, -164.24312146205602, -511.26830100979112, -9.5943138644072974, 431.19011875204285, -132.14180642559279);
            double4x4 r2 = double4x4(48256.879785884317, 173056.43945786267, 222948.84060419552, -115371.07059366687, 229848.81906041352, 73141.066311099828, -16041.64059038324, 21481.810956341167, -236681.80623072633, 145989.63607064, 167088.0691738516, -83414.364672835931, -259658.48753029478, -4872.676483174394, 218989.07843891438, -67111.0286482113);
            TestUtils.AreEqual(a2 * b2, r2);

            double a3 = (-87.502642910695954);
            double4x4 b3 = double4x4(384.61864513187606, 385.83906167831231, -384.6230682733576, 236.27862869774856, 336.44521371295923, 272.74445951764676, -121.14546900668438, -194.38113197795167, -364.7452964097007, 360.35692303271821, -153.58247644900462, 63.941664487096318, 0.043457269688815359, -430.97399278682377, -126.42789679692493, -338.74861613789039);
            double4x4 r3 = double4x4(-33655.147961770235, -33761.937635035356, 33655.534998339841, -20675.004474368008, -29439.845394537857, -23865.861047043414, 10600.548714740688, 17008.862780043568, 31916.177425093992, -31532.183156529089, 13438.872594057622, -5595.064634729918, -3.8026259514542216, 37711.363394622291, 11062.775107371643, 29641.39919440624);
            TestUtils.AreEqual(a3 * b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_div_wide_wide()
        {
            double4x4 a0 = double4x4(246.26574933075619, -269.85612953354428, -451.61952588130697, -7.38850236283082, -308.20558681534862, -373.394808704683, 360.41863482092447, 25.80972458133931, -274.050461181463, 127.53858977534742, -447.6717600522897, -137.4586017771897, -136.13317424437645, 12.43763423545181, 228.51298319013461, 356.9723681681661);
            double4x4 b0 = double4x4(172.11981423763552, -77.141104972521362, -325.8353723612779, -450.60868117334724, -261.26215398556656, -122.44949847201326, -93.210781379235357, -442.00522705633438, 484.36271380091216, -390.78178686219348, 402.02531714086672, 316.65072193585831, 397.15440744774151, -303.26218643005109, -118.59124451437555, -81.650312223308845);
            double4x4 r0 = double4x4(1.4307809383918566, 3.4982144685336105, 1.3860359070548143, 0.016396715535066435, 1.1796794220427942, 3.0493780159501847, -3.8667054335113131, -0.05839235149599218, -0.56579594872388561, -0.32636779415802974, -1.1135412148569459, -0.43410165287743668, -0.3427714050039572, -0.041012809351094658, -1.9268959030313104, -4.37196574572633);
            TestUtils.AreEqual(a0 / b0, r0);

            double4x4 a1 = double4x4(-24.762040865031111, 411.66839356518744, -204.07890067066944, 11.365393882321882, 82.152295389283609, 37.389483230835481, 394.26582903147948, -429.91279645912016, 315.37384071730719, -122.66599255551864, 447.52615067340719, -210.48151574399395, -202.42158398517483, -453.00793072814491, 173.7269934032704, -167.1216643634819);
            double4x4 b1 = double4x4(-84.346871176896116, -488.41943549011808, 404.16049999937434, -136.72883731533256, -19.832707652744261, -102.6072290421497, 166.11604960547572, -112.84016590604568, -218.2096851888158, 458.51754042995981, 119.5872405132219, 356.24043218988948, -74.506851469402591, -336.77393332904853, -216.12631593277973, 322.385657699027);
            double4x4 r1 = double4x4(0.29357391115432163, -0.84285833783843456, -0.50494519051462317, -0.083123605125890912, -4.1422632162843458, -0.36439423985883462, 2.3734361006528726, 3.8099270149698223, -1.4452788401413792, -0.26752737188743669, 3.7422566885296384, -0.59084117557941718, 2.7168183864044027, 1.3451395309907455, -0.80382156450260089, -0.51839050643966134);
            TestUtils.AreEqual(a1 / b1, r1);

            double4x4 a2 = double4x4(-106.2345221537326, 414.31254239301779, 7.1208250555772565, 274.07367361433512, -39.002680081409721, 39.065917748522907, -147.36416608996882, 434.38489290437894, 315.06720390686166, -106.63602714735828, -507.92525195885696, -17.176462896716089, -385.86535543290216, 226.00214849505676, 345.16843072751931, 201.5441692813971);
            double4x4 b2 = double4x4(220.25550351862591, -67.234494002179474, 2.229160071457386, -166.21096118083733, -247.73257290932003, 84.1609476004545, 477.14862726496006, 209.75077615014777, -386.72219985850256, -65.2773316210496, 410.45482773820629, 367.65071862174693, -456.57203862470203, 382.42795079873315, -163.86067278862964, -213.72138867793672);
            double4x4 r2 = double4x4(-0.48232403030396409, -6.1622021336189041, 3.1943982609206638, -1.6489506568471335, 0.15743864290178045, 0.464181058582947, -0.3088433198156047, 2.0709572611708924, -0.81471196642484278, 1.6335843469583855, -1.2374693087611059, -0.046719514002603893, 0.84513575687905829, 0.59096660697271775, -2.1064751221470064, -0.94302292591365366);
            TestUtils.AreEqual(a2 / b2, r2);

            double4x4 a3 = double4x4(-364.71104328926236, -508.3727068884171, 263.80350721245793, 392.03900903837712, 19.716641196849082, -14.47977948863047, -431.47867723530095, -8.3954017201417059, 3.1082556262184653, -139.84113723591025, 402.5097112145786, 318.31090965788383, -274.56803358465811, -193.36913856927731, 288.22701157640063, 0.62060809164336206);
            double4x4 b3 = double4x4(227.00382553180862, -337.98967448714643, 149.32169754305937, -198.85531935415014, -468.45503137468131, 183.25872358272727, 217.35753665555148, -167.57021125013483, -150.75870687829268, 48.449193261772962, 410.15566725756776, -4.689349891938889, -465.33817622872914, -48.307136319720712, 403.64572281560197, -387.14200729278008);
            double4x4 r3 = double4x4(-1.6066295025418313, 1.5041072117359913, 1.7666789994560961, -1.9714786122476196, -0.042088652861707126, -0.079012770609492758, -1.9851102652081911, 0.0501008004794465, -0.02061742031740665, -2.8863460425510681, 0.98135840449526768, -67.87953916705348, 0.59003977668425556, 4.0029104041577614, 0.7140593725752713, -0.0016030502501735);
            TestUtils.AreEqual(a3 / b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_div_wide_scalar()
        {
            double4x4 a0 = double4x4(-244.51745116175965, 69.112274917360537, -333.02311888943575, 257.39682519500923, 403.24561257066466, 154.34436066185322, 131.52659160062979, -261.88639200007844, -348.92380516087815, -275.53868187383688, 210.55792174607416, 287.64239968342815, 504.37224626185946, 491.78708600056689, -26.63160015392657, -253.23667275776933);
            double b0 = (-60.024377612408443);
            double4x4 r0 = double4x4(4.0736357608014941, -1.1514034408425655, 5.5481311449798705, -4.2882048166676752, -6.7180307170282818, -2.5713612835520117, -2.1912195816494422, 4.3630005410658415, 5.8130349541308268, 4.590446295887566, -3.507873469437639, -4.7920929982948417, -8.4027901050254936, -8.193122620548472, 0.44367973835385832, 4.2188971019904313);
            TestUtils.AreEqual(a0 / b0, r0);

            double4x4 a1 = double4x4(272.89512098622276, -460.87559030059521, -502.64601611655485, -84.324793139623864, -174.69034036187935, 83.796309271732525, 197.04206690427009, 317.16826525198678, 403.38711781212464, 81.646461763254592, 60.606869964211683, -413.56048102563273, 207.34099803089214, 358.5621036768714, 20.749072799807891, -68.577131064877449);
            double b1 = (178.09617313095191);
            double4x4 r1 = double4x4(1.5322907628428735, -2.5877905302418771, -2.8223291229675409, -0.47347897294581892, -0.98087644046922728, 0.47051156573767666, 1.1063801284454748, 1.7808819789674923, 2.2649959890801195, 0.45844029283673021, 0.34030416767938187, -2.3221188516024251, 1.164208047740795, 2.01330605466309, 0.1165048773089097, -0.38505673569107818);
            TestUtils.AreEqual(a1 / b1, r1);

            double4x4 a2 = double4x4(310.70246257945075, 147.86623079509764, 506.6588964437409, -435.77857300070048, 210.67294011389504, -218.78147636110964, -19.190853366251474, 416.5117301496266, 427.01360555506017, 417.1994099175555, -150.91182310456031, 488.98551463009119, -294.73874129668752, -357.29805271574207, 288.77164591884787, 453.4291381563196);
            double b2 = (417.40490193730443);
            double4x4 r2 = double4x4(0.74436706693521115, 0.35425130397080873, 1.213830729088665, -1.0440188195637334, 0.50472080978468914, -0.52414687835642937, -0.045976588384996978, 0.9978601789688325, 1.0230201024788133, 0.99950769140756335, -0.3615477978436098, 1.1714896311963734, -0.70612189729616126, -0.8559986982841169, 0.69182619700576087, 1.0863052543269511);
            TestUtils.AreEqual(a2 / b2, r2);

            double4x4 a3 = double4x4(70.724425587209112, 425.52822633531332, 109.51968412730832, 351.80734197786421, -397.33403725052904, 497.315965645628, -18.065185793705837, 452.22855994302245, 511.85849475854, -439.30210110140132, -441.0802783635819, -360.32591097444572, -44.264803191770227, -122.10078555070834, -322.19115105373373, -155.7804692516944);
            double b3 = (-235.77751051437923);
            double4x4 r3 = double4x4(-0.29996255975777586, -1.8047871716304422, -0.46450437061777827, -1.492115771391219, 1.6852075347801123, -2.1092595496519948, 0.076619630745503625, -1.9180309392377042, -2.1709385837599791, 1.8632061223439282, 1.8707478817691647, 1.528245464074788, 0.1877397173937447, 0.51786442771547481, 1.366505017169924, 0.66070961947065732);
            TestUtils.AreEqual(a3 / b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_div_scalar_wide()
        {
            double a0 = (41.737658758525527);
            double4x4 b0 = double4x4(-422.676129776368, 248.12963235011773, 449.39137741988122, 245.85813796047967, -326.62061253498337, 163.71510489457989, 333.664472020075, 38.291076916405473, -472.97976062864984, 192.23013958345643, -200.29686960964318, -490.18150376257557, -211.10257468517057, -322.85234108700058, -137.98529035317961, 84.32973555677097);
            double4x4 r0 = double4x4(-0.098746193168297289, 0.1682090863683405, 0.092875967042706856, 0.16976317767945767, -0.12778635871933872, 0.25494079355354177, 0.12508871114097631, 1.0900100524632514, -0.088244069266411956, 0.21712338579666474, -0.20837898685020731, -0.08514735549618288, -0.19771269403403205, -0.12927785692369589, -0.3024790443365093, 0.49493406427709763);
            TestUtils.AreEqual(a0 / b0, r0);

            double a1 = (355.06345550858578);
            double4x4 b1 = double4x4(276.42724455354141, -382.9880213136729, -488.647160996053, 344.84603826368505, 168.85499938244698, -44.19558837087618, 420.550703959796, -175.6152060849663, -9.2205684227964753, -344.19428865248074, -449.07149216582604, 117.70491724726969, -337.02741710144437, 239.39341389359595, -389.35516304027067, 242.71606718875285);
            double4x4 r1 = double4x4(1.2844734464652714, -0.92708762611085294, -0.72662543415749792, 1.0296289245378776, 2.1027713529783458, -8.033911722794576, 0.84428215709877708, -2.0218263749711896, -38.507762127847187, -1.0315785799312875, -0.79066131273697848, 3.0165558399117933, -1.0535150480108051, 1.4831797154887565, -0.91192692228884575, 1.4628757775333587);
            TestUtils.AreEqual(a1 / b1, r1);

            double a2 = (496.27646445495839);
            double4x4 b2 = double4x4(91.745798392102984, -490.49213360738577, 485.75540922850155, -317.57225504404505, -451.62477871944418, 394.01837677230048, -262.27140939527726, -314.24678697914203, 359.91591446470284, -101.61536865197837, 359.5172828917938, -424.97987981558771, -192.71958431635034, -169.7497170761925, -244.79002224877013, -187.14385255945092);
            double4x4 r2 = double4x4(5.4092554989163988, -1.011792912569323, 1.0216591622585671, -1.5627198427209212, -1.0988689900100732, 1.2595261889060365, -1.8922247972023705, -1.5792570839806184, 1.3788677980329445, -4.8838721055537526, 1.3803966820819735, -1.1677646119865923, -2.5751221196093783, -2.9235775646813225, -2.02735577167689, -2.6518448651542204);
            TestUtils.AreEqual(a2 / b2, r2);

            double a3 = (-207.71366343633906);
            double4x4 b3 = double4x4(-370.15405886720589, 58.676935461665039, -123.14700728428875, 208.89162049484048, -79.531129158814963, -219.67477927900609, -483.15932653991473, -90.52665595455403, 194.59995588781305, -4.0906064529393689, 270.735964185901, 432.58615966913578, 376.04765647279453, 464.83672568986037, -322.94170656937251, -220.89757095132842);
            double4x4 r3 = double4x4(0.5611546286214224, -3.5399541881672238, 1.6867130433533437, -0.99436091761023748, 2.6117278307662097, 0.94555080067942, 0.42990717973686765, 2.2945027765149635, -1.0673880293995857, 50.778207541105104, -0.76721858531403808, -0.48016715004291677, -0.55235994656801235, -0.44685295278266346, 0.64319243755442035, 0.94031664785533453);
            TestUtils.AreEqual(a3 / b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_mod_wide_wide()
        {
            double4x4 a0 = double4x4(-442.30985924336585, 368.50046246522129, -1.0938966279355213, -364.67383473211612, -197.34394487987458, -34.034902350062, -101.34858350704826, 208.31857142612273, -140.77031404374645, 183.446989383291, -463.36838100076113, 83.839106360375467, -64.714058190916717, 295.06681050689281, 212.257051805154, 349.62829916068745);
            double4x4 b0 = double4x4(-43.245045443645211, -144.19587690392319, -62.640481739603217, -336.82826510855381, -154.6102545981343, -154.02935583611452, 487.0462093237071, -469.82909105244516, -145.20377237405802, -203.38401780062543, -22.520082245823062, 224.6900237652892, -435.62674614210925, 12.095571285158144, 40.378765363422531, 345.78484813579587);
            double4x4 r0 = double4x4(-9.8594048069137443, 80.1087086573749, -1.0938966279355213, -27.845569623562312, -42.73369028174028, -34.034902350062, -101.34858350704826, 208.31857142612273, -140.77031404374645, 183.446989383291, -12.966736084299896, 83.839106360375467, -64.714058190916717, 4.773099663097355, 10.363224988041338, 3.8434510248915785);
            TestUtils.AreEqual(a0 % b0, r0);

            double4x4 a1 = double4x4(119.87592106679267, -37.805828350505692, 142.41158515886013, 332.24425593588694, -464.19427249589671, -296.14783801517814, 225.17535863871467, -212.06027732233531, 156.98570425668061, 507.61831092630439, 270.83043897842538, 337.734341063413, 384.91584819597927, 432.51818128699347, 154.29270775350403, -37.0853169137078);
            double4x4 b1 = double4x4(-433.47126146474443, -355.64996712079733, 4.0154273528677322, 66.659781725453058, -221.85363088448236, -355.05676405274158, 357.93597118832918, 71.375334057666009, -131.41830188195144, -473.98760078567432, 76.2178585884244, 92.210223002457155, -368.18956130006796, -77.467150485826267, 135.23059398272574, 274.27728975670288);
            double4x4 r1 = double4x4(119.87592106679267, -37.805828350505692, 1.8716278084895066, 65.605129034074707, -20.487010726932, -296.14783801517814, 225.17535863871467, -69.309609207003291, 25.56740237472917, 33.630710140630072, 42.17686321315216, 61.103672056041546, 16.7262868959113, 45.182428857862135, 19.062113770778296, -37.0853169137078);
            TestUtils.AreEqual(a1 % b1, r1);

            double4x4 a2 = double4x4(7.7614462411783052, 238.09472309709281, 12.852037674212852, -100.2406762113053, 34.551971690054984, -251.18974530472872, -238.37224423064487, 511.51466512657453, 288.43353118022605, 367.10986702847754, 44.760454437118256, -437.04559084262962, -259.20560252815744, -228.56581531677665, 83.497246065874265, 424.36707397194914);
            double4x4 b2 = double4x4(132.18024951414213, -179.87732204230377, 51.968538546920058, 367.21425860338582, -395.21279234216212, 270.48524988372128, -73.104129586882948, 89.3499706207541, -288.30852355077332, -168.32464631289463, 311.61589994636176, -468.34193752163179, 381.9839486470371, -1.398853541071901, -102.28859357828674, -87.424866478622391);
            double4x4 r2 = double4x4(7.7614462411783052, 58.217401054789036, 12.852037674212852, -100.2406762113053, 34.551971690054984, -251.18974530472872, -19.059855469996023, 64.764812022804, 0.12500762945273891, 30.46057440268828, 44.760454437118256, -437.04559084262962, -259.20560252815744, -0.552688122056793, 83.497246065874265, 74.667608057459574);
            TestUtils.AreEqual(a2 % b2, r2);

            double4x4 a3 = double4x4(327.23168602922544, 149.18178970608017, -392.15875190876363, -453.47670361654679, 480.82237432935381, 3.460427524270699, -184.59239610684682, -181.41753276689792, -367.70422642664249, 146.09931833394774, 280.12072695424808, -282.48316468041537, 57.225840356771755, -432.67171951414633, -231.46564613630329, -228.28298746248845);
            double4x4 b3 = double4x4(-58.425127771881023, -419.00489087542746, 479.81704471996852, -406.98283429023945, -371.59594767708143, 154.04323132058755, -444.75090882030827, -53.98002221713773, -168.83178933376064, -69.398768695722708, -380.76067060081323, 208.14554629481654, 194.43666061872466, 142.86808902717576, 413.15817732976666, -375.15943473165828);
            double4x4 r3 = double4x4(35.106047169820329, 149.18178970608017, -392.15875190876363, -46.493869326307333, 109.22642665227238, 3.460427524270699, -184.59239610684682, -19.477466115484731, -30.040647759121214, 7.3017809425023188, 280.12072695424808, -74.33761838559883, 57.225840356771755, -4.0674524326190635, -231.46564613630329, -228.28298746248845);
            TestUtils.AreEqual(a3 % b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_mod_wide_scalar()
        {
            double4x4 a0 = double4x4(-433.41699548876704, -5.5141427542614565, 393.39439958771425, 299.41153277988155, -120.80601626299602, -502.939041133476, -450.80766245853511, 186.09479698263794, -84.473635951277629, -318.78148356023314, 433.45469041981482, -54.6001856581309, -172.33886607565864, -429.71466728193434, 222.36186109406958, 5.796394112425105);
            double b0 = (-90.499235433758827);
            double4x4 r0 = double4x4(-71.420053753731736, -5.5141427542614565, 31.39745785267894, 27.913826478605074, -30.306780829237198, -50.442863964681862, -88.8107207234998, 5.0963261151202914, -84.473635951277629, -47.283777258956661, 71.457748684779517, -54.6001856581309, -81.839630641899817, -67.717725546899032, 41.363390226551928, 5.796394112425105);
            TestUtils.AreEqual(a0 % b0, r0);

            double4x4 a1 = double4x4(254.51082885196, -203.08261284748215, -75.356399809641971, 252.28909385031511, -69.403906139267576, 5.3372299696026175, -279.06042803407666, 483.55059097872606, -331.99334660730949, 335.99997655302286, 67.839589388966374, -124.72076731767544, 38.175906437531125, 271.28698671575955, 405.77360100567978, -194.76144489774549);
            double b1 = (-433.09369703433185);
            double4x4 r1 = double4x4(254.51082885196, -203.08261284748215, -75.356399809641971, 252.28909385031511, -69.403906139267576, 5.3372299696026175, -279.06042803407666, 50.45689394439421, -331.99334660730949, 335.99997655302286, 67.839589388966374, -124.72076731767544, 38.175906437531125, 271.28698671575955, 405.77360100567978, -194.76144489774549);
            TestUtils.AreEqual(a1 % b1, r1);

            double4x4 a2 = double4x4(235.72397314557986, -304.153164289963, -295.52024735860539, 313.72239532774427, -232.20264135683078, 191.61973127705028, 244.09660899084838, 162.52424080787421, 390.01615423244243, 90.004538339564874, 155.93352062810845, 217.33769641506376, -306.81927671414769, 149.09372074394196, 503.82839917756075, -194.13014063338289);
            double b2 = (465.98487804177444);
            double4x4 r2 = double4x4(235.72397314557986, -304.153164289963, -295.52024735860539, 313.72239532774427, -232.20264135683078, 191.61973127705028, 244.09660899084838, 162.52424080787421, 390.01615423244243, 90.004538339564874, 155.93352062810845, 217.33769641506376, -306.81927671414769, 149.09372074394196, 37.843521135786318, -194.13014063338289);
            TestUtils.AreEqual(a2 % b2, r2);

            double4x4 a3 = double4x4(214.86302171222076, 225.99642787966707, -102.91396265053839, -173.70608933908215, 490.90467070550881, 501.14862727613593, 160.45482762179097, 327.86094180115538, -300.81266965568659, -326.9390176864988, -6.6472518475014795, -201.18443569968662, 389.35045761119125, -78.068470275992752, -484.31891058586484, -371.83874076038541);
            double b3 = (198.77008280473297);
            double4x4 r3 = double4x4(16.092938907487792, 27.226345074934102, -102.91396265053839, -173.70608933908215, 93.364505096042876, 103.60846166667, 160.45482762179097, 129.09085899642241, -102.04258685095363, -128.16893488176584, -6.6472518475014795, -2.4143528949536517, 190.58037480645828, -78.068470275992752, -86.778744976398912, -173.06865795565244);
            TestUtils.AreEqual(a3 % b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_mod_scalar_wide()
        {
            double a0 = (-396.4224028049141);
            double4x4 b0 = double4x4(-159.14024384279747, 230.17333399046834, 14.779358632294134, -303.15649738123477, 399.63502020371845, 206.69470534412881, 397.04482263934096, -393.89064735634747, -372.06709426085797, 201.01229796233224, -95.5668547598491, -258.95146882671463, 106.98357563232241, 469.3235559264773, -34.808985011097491, 184.83653434777466);
            double4x4 r0 = double4x4(-78.141915119319151, -166.24906881444576, -12.159078365266623, -93.265905423679328, -396.4224028049141, -189.72769746078529, -396.4224028049141, -2.5317554485666278, -24.355308544056129, -195.41010484258186, -14.154983765517727, -137.47093397819947, -75.47167590794686, -396.4224028049141, -13.523567682841701, -26.749334109364781);
            TestUtils.AreEqual(a0 % b0, r0);

            double a1 = (374.79425376224992);
            double4x4 b1 = double4x4(-131.87271911086174, -120.09286003936683, 4.506670715523228, -111.40195732535886, 391.54249710195813, -218.66887078931035, 196.37741980160467, -511.03262233689082, 499.95350598727987, -433.52306505363578, -163.8668559360629, 177.00401099818009, 110.65016441729392, 17.68454910148148, -95.85296754532169, -432.44096561541824);
            double4x4 r1 = double4x4(111.04881554052645, 14.515673644149444, 0.74058437382200282, 40.588381786173329, 374.79425376224992, 156.12538297293958, 178.41683396064525, 374.79425376224992, 374.79425376224992, 374.79425376224992, 47.060541890124114, 20.786231765889738, 42.843760510368156, 3.4187226311388486, 87.235351126284854, 374.79425376224992);
            TestUtils.AreEqual(a1 % b1, r1);

            double a2 = (192.69208654793545);
            double4x4 b2 = double4x4(-268.13177621929526, 271.07511461483091, 423.70268912972074, -413.23324675729185, 127.95621091125361, -298.20467843590518, -352.41809122283854, -175.60771592688172, -152.89928944078241, 34.619420306114193, -380.80295556634803, 0.35205721871557216, 485.90088986135129, 266.1508249091687, 483.82075928329527, 11.777843242407698);
            double4x4 r2 = double4x4(192.69208654793545, 192.69208654793545, 192.69208654793545, 192.69208654793545, 64.73587563668184, 192.69208654793545, 192.69208654793545, 17.084370621053722, 39.792797107153035, 19.594985017364479, 192.69208654793545, 0.11678791051747339, 192.69208654793545, 192.69208654793545, 192.69208654793545, 4.2465946694122749);
            TestUtils.AreEqual(a2 % b2, r2);

            double a3 = (274.1358426893762);
            double4x4 b3 = double4x4(313.07315769469051, -102.217432308112, -88.03518657015411, 226.97955452044471, -38.682740944755608, -63.157795220221317, 330.40193883068946, -304.12387504434395, 411.68151421643859, 128.21777039776453, 48.911678575403812, -58.894658354527621, 29.282741321848107, -328.67225113914918, -511.7138872145274, -338.5105032112964);
            double4x4 r3 = double4x4(274.1358426893762, 69.700978073152214, 10.030282978913874, 47.156288168931496, 3.3566560760869493, 21.504661808490937, 274.1358426893762, 274.1358426893762, 274.1358426893762, 17.700301893847154, 29.577449812357145, 38.55720927126572, 10.591170792743242, 274.1358426893762, 274.1358426893762, 274.1358426893762);
            TestUtils.AreEqual(a3 % b3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_plus()
        {
            double4x4 a0 = double4x4(271.6708086802023, -79.080240524876956, -330.98506203805334, 31.824682965793045, 315.44952860262686, 319.22218742930431, 190.32466015141677, -350.30858270745193, -320.51845875406565, 102.0544069288552, -107.00351267075331, -428.77622075973835, 377.23016208095021, 234.77393042052813, 34.283600107898792, 258.33039414991174);
            double4x4 r0 = double4x4(271.6708086802023, -79.080240524876956, -330.98506203805334, 31.824682965793045, 315.44952860262686, 319.22218742930431, 190.32466015141677, -350.30858270745193, -320.51845875406565, 102.0544069288552, -107.00351267075331, -428.77622075973835, 377.23016208095021, 234.77393042052813, 34.283600107898792, 258.33039414991174);
            TestUtils.AreEqual(+a0, r0);

            double4x4 a1 = double4x4(465.35593555185756, -316.93713655925222, -230.05266557915724, 301.78512229667285, 2.585727931273027, 350.24640981771347, 60.819777278611355, -472.44209526127304, -364.80255644619581, 239.15236937215195, 473.8031363309376, 285.80893935161123, -273.26378191321334, -206.68638310520276, -113.36231785331029, -351.7548708169511);
            double4x4 r1 = double4x4(465.35593555185756, -316.93713655925222, -230.05266557915724, 301.78512229667285, 2.585727931273027, 350.24640981771347, 60.819777278611355, -472.44209526127304, -364.80255644619581, 239.15236937215195, 473.8031363309376, 285.80893935161123, -273.26378191321334, -206.68638310520276, -113.36231785331029, -351.7548708169511);
            TestUtils.AreEqual(+a1, r1);

            double4x4 a2 = double4x4(-116.53621798219916, -330.00534716714424, -379.67424100436006, -339.673203864914, -29.083537353707243, 62.20109441792647, 485.92661713339692, 183.72484144183102, -258.39246022812671, 486.44689463379177, 245.99093138705518, 231.85467468567879, -216.48996482439804, -163.00918181380683, 175.32546266136944, 404.37801499123589);
            double4x4 r2 = double4x4(-116.53621798219916, -330.00534716714424, -379.67424100436006, -339.673203864914, -29.083537353707243, 62.20109441792647, 485.92661713339692, 183.72484144183102, -258.39246022812671, 486.44689463379177, 245.99093138705518, 231.85467468567879, -216.48996482439804, -163.00918181380683, 175.32546266136944, 404.37801499123589);
            TestUtils.AreEqual(+a2, r2);

            double4x4 a3 = double4x4(87.649255078122565, -236.10903917816887, 6.5089323550970448, 481.88568638352945, -368.85402863512468, 82.673349657409517, 120.1951606833353, -7.7332217729339732, 168.25208504882278, -431.93018194284764, 228.52152382047916, -124.11752205906322, 464.74532315914769, -203.25920996594203, -505.641194817443, 434.9786500572128);
            double4x4 r3 = double4x4(87.649255078122565, -236.10903917816887, 6.5089323550970448, 481.88568638352945, -368.85402863512468, 82.673349657409517, 120.1951606833353, -7.7332217729339732, 168.25208504882278, -431.93018194284764, 228.52152382047916, -124.11752205906322, 464.74532315914769, -203.25920996594203, -505.641194817443, 434.9786500572128);
            TestUtils.AreEqual(+a3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_neg()
        {
            double4x4 a0 = double4x4(420.22718854445372, -196.25749811728366, -335.42683068636188, 509.04366969924592, -33.014395013923945, -498.57532071442125, -495.8379526063045, -270.85946787095605, 19.686896571743773, 268.23670662019254, -180.60051473444349, 223.38126312167446, -410.39206070936848, -395.68154186554324, -349.14948885010062, -110.9393032113739);
            double4x4 r0 = double4x4(-420.22718854445372, 196.25749811728366, 335.42683068636188, -509.04366969924592, 33.014395013923945, 498.57532071442125, 495.8379526063045, 270.85946787095605, -19.686896571743773, -268.23670662019254, 180.60051473444349, -223.38126312167446, 410.39206070936848, 395.68154186554324, 349.14948885010062, 110.9393032113739);
            TestUtils.AreEqual(-a0, r0);

            double4x4 a1 = double4x4(-238.21960913307015, 469.29257867731735, 48.290685914592245, 88.7237785275671, 66.148520738886873, 55.707977559281517, 464.54141090090457, 499.24280213715645, 175.01502259774838, 196.38759169186824, -306.1655677790593, 149.66006023700356, 320.3917383255399, -359.83381168909079, 22.03845144344416, -159.55426199713457);
            double4x4 r1 = double4x4(238.21960913307015, -469.29257867731735, -48.290685914592245, -88.7237785275671, -66.148520738886873, -55.707977559281517, -464.54141090090457, -499.24280213715645, -175.01502259774838, -196.38759169186824, 306.1655677790593, -149.66006023700356, -320.3917383255399, 359.83381168909079, -22.03845144344416, 159.55426199713457);
            TestUtils.AreEqual(-a1, r1);

            double4x4 a2 = double4x4(419.82245011805674, 363.71671049842462, 280.88790405955535, -270.65131939139746, -201.61574015469091, 325.03162899847689, 95.489228054643263, 191.07025322274785, 371.97357361948752, 296.51257981756362, -164.16993697181806, -347.45810691800813, -237.40496050445591, -228.70196615378467, 61.082260875535326, 128.33153134599866);
            double4x4 r2 = double4x4(-419.82245011805674, -363.71671049842462, -280.88790405955535, 270.65131939139746, 201.61574015469091, -325.03162899847689, -95.489228054643263, -191.07025322274785, -371.97357361948752, -296.51257981756362, 164.16993697181806, 347.45810691800813, 237.40496050445591, 228.70196615378467, -61.082260875535326, -128.33153134599866);
            TestUtils.AreEqual(-a2, r2);

            double4x4 a3 = double4x4(331.25579587149241, -501.02881764854715, 160.58019001808952, -180.49658998311338, 127.97833853959025, 260.03452432343477, -287.96824158726645, -502.19913243791046, 303.97058238832778, -182.96291240628943, 322.3276151727548, 91.480471892040441, 211.29515824620387, 116.07051830928333, 309.36103382211229, -129.06447488119102);
            double4x4 r3 = double4x4(-331.25579587149241, 501.02881764854715, -160.58019001808952, 180.49658998311338, -127.97833853959025, -260.03452432343477, 287.96824158726645, 502.19913243791046, -303.97058238832778, 182.96291240628943, -322.3276151727548, -91.480471892040441, -211.29515824620387, -116.07051830928333, -309.36103382211229, 129.06447488119102);
            TestUtils.AreEqual(-a3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_prefix_inc()
        {
            double4x4 a0 = double4x4(-99.79557113526181, 458.74185082816609, 96.179026886904126, -48.552469514567633, -315.728967098393, -299.23014583216525, -323.61485853959567, -456.89028832730384, -76.507656371457358, -305.58477344437722, 64.0964734852763, 148.67930967578627, 363.2849182390072, -115.5592263283018, -326.87781992874937, -179.89464839729231);
            double4x4 r0 = double4x4(-98.79557113526181, 459.74185082816609, 97.179026886904126, -47.552469514567633, -314.728967098393, -298.23014583216525, -322.61485853959567, -455.89028832730384, -75.507656371457358, -304.58477344437722, 65.0964734852763, 149.67930967578627, 364.2849182390072, -114.5592263283018, -325.87781992874937, -178.89464839729231);
            TestUtils.AreEqual(++a0, r0);

            double4x4 a1 = double4x4(339.8765849265626, -153.3736775635619, 261.62557304167444, 155.03081877298223, -396.65022892348946, 301.30576791488829, -221.35540328796736, -429.69815011960367, -271.28932893988178, -264.38006246480165, -377.55920785365589, 223.23241792583485, -71.076339993195745, -388.22791713673058, 131.28316909227669, 22.304934273615913);
            double4x4 r1 = double4x4(340.8765849265626, -152.3736775635619, 262.62557304167444, 156.03081877298223, -395.65022892348946, 302.30576791488829, -220.35540328796736, -428.69815011960367, -270.28932893988178, -263.38006246480165, -376.55920785365589, 224.23241792583485, -70.076339993195745, -387.22791713673058, 132.28316909227669, 23.304934273615913);
            TestUtils.AreEqual(++a1, r1);

            double4x4 a2 = double4x4(-480.76047228312143, 117.95409851798513, 139.52581245243823, 335.68968192473505, 162.6615141195532, -256.04508340360837, -254.73151385725083, -89.256037038404486, 314.36555233335378, 244.72812830876933, 34.010626570326622, -90.445278448260069, -472.63621614530507, -34.566777483824069, -71.271847996521672, -396.49010748252743);
            double4x4 r2 = double4x4(-479.76047228312143, 118.95409851798513, 140.52581245243823, 336.68968192473505, 163.6615141195532, -255.04508340360837, -253.73151385725083, -88.256037038404486, 315.36555233335378, 245.72812830876933, 35.010626570326622, -89.445278448260069, -471.63621614530507, -33.566777483824069, -70.271847996521672, -395.49010748252743);
            TestUtils.AreEqual(++a2, r2);

            double4x4 a3 = double4x4(-314.987458614161, 63.450377255422268, 474.66809890916022, 257.1736100917559, 128.10716706519349, -354.56391708672231, -194.46556982512845, -130.85431939496397, 467.56036184148877, 477.1499166326364, -458.05565068593978, -168.12270625313869, 506.56868362173839, -429.35685630764664, 444.81330439299961, -385.62562459782959);
            double4x4 r3 = double4x4(-313.987458614161, 64.450377255422268, 475.66809890916022, 258.1736100917559, 129.10716706519349, -353.56391708672231, -193.46556982512845, -129.85431939496397, 468.56036184148877, 478.1499166326364, -457.05565068593978, -167.12270625313869, 507.56868362173839, -428.35685630764664, 445.81330439299961, -384.62562459782959);
            TestUtils.AreEqual(++a3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_postfix_inc()
        {
            double4x4 a0 = double4x4(322.94356623429042, 472.05246542024076, 203.48761925636211, -49.854570650427888, -31.420532002775246, 455.33662459595905, 271.45466840986842, 55.736877228942149, 153.75031645305, -174.17301925186672, -427.40105100506969, 215.11022744658874, 159.86103184514729, -333.05045262586816, 241.46487509527469, 287.22045649551808);
            double4x4 r0 = double4x4(322.94356623429042, 472.05246542024076, 203.48761925636211, -49.854570650427888, -31.420532002775246, 455.33662459595905, 271.45466840986842, 55.736877228942149, 153.75031645305, -174.17301925186672, -427.40105100506969, 215.11022744658874, 159.86103184514729, -333.05045262586816, 241.46487509527469, 287.22045649551808);
            TestUtils.AreEqual(a0++, r0);

            double4x4 a1 = double4x4(-170.10464366250886, -162.86024792625579, 454.48881003562769, -449.92732045144186, 209.52264294844247, -311.43587103087259, 69.731466087387616, -232.29964433996923, -341.49855271982892, 188.00656685047159, 417.72977919957123, 25.565661203845252, -463.72565982478005, 504.44898509627626, -310.1449584020977, -117.39846258861871);
            double4x4 r1 = double4x4(-170.10464366250886, -162.86024792625579, 454.48881003562769, -449.92732045144186, 209.52264294844247, -311.43587103087259, 69.731466087387616, -232.29964433996923, -341.49855271982892, 188.00656685047159, 417.72977919957123, 25.565661203845252, -463.72565982478005, 504.44898509627626, -310.1449584020977, -117.39846258861871);
            TestUtils.AreEqual(a1++, r1);

            double4x4 a2 = double4x4(403.50871271803453, 446.60767313773169, -12.352577930480493, -232.15012251220185, 64.577020436793987, -10.59072947995304, 193.58436617328994, 382.05033582358169, -462.06412789880488, -122.30657368633268, 428.77629562317225, 338.97875825454423, 227.54409729109341, -169.32121356265674, -95.765601917992171, -169.85535796445578);
            double4x4 r2 = double4x4(403.50871271803453, 446.60767313773169, -12.352577930480493, -232.15012251220185, 64.577020436793987, -10.59072947995304, 193.58436617328994, 382.05033582358169, -462.06412789880488, -122.30657368633268, 428.77629562317225, 338.97875825454423, 227.54409729109341, -169.32121356265674, -95.765601917992171, -169.85535796445578);
            TestUtils.AreEqual(a2++, r2);

            double4x4 a3 = double4x4(439.299990143301, -424.34972520561411, 63.862382203276411, 260.87088668573222, 350.98539583337742, 271.48833645111335, -378.24384683102551, -329.55492631045865, -201.92197928294632, -244.66994225451253, 365.72488921029719, -481.82878397490305, 105.47597627783011, -166.62200434814298, 394.743907397028, -179.49130996479249);
            double4x4 r3 = double4x4(439.299990143301, -424.34972520561411, 63.862382203276411, 260.87088668573222, 350.98539583337742, 271.48833645111335, -378.24384683102551, -329.55492631045865, -201.92197928294632, -244.66994225451253, 365.72488921029719, -481.82878397490305, 105.47597627783011, -166.62200434814298, 394.743907397028, -179.49130996479249);
            TestUtils.AreEqual(a3++, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_prefix_dec()
        {
            double4x4 a0 = double4x4(-416.20121712992022, -96.637880131899351, -50.145671629414721, -207.31644759295341, 439.47906156977592, -304.40081920493435, 337.96895734312432, 246.08898293510492, 171.96452935597142, -227.44280134301761, 298.28480710568135, 326.50782338087811, 400.720900006928, -478.03137253133178, -326.45297852459038, -24.584499132160317);
            double4x4 r0 = double4x4(-417.20121712992022, -97.637880131899351, -51.145671629414721, -208.31644759295341, 438.47906156977592, -305.40081920493435, 336.96895734312432, 245.08898293510492, 170.96452935597142, -228.44280134301761, 297.28480710568135, 325.50782338087811, 399.720900006928, -479.03137253133178, -327.45297852459038, -25.584499132160317);
            TestUtils.AreEqual(--a0, r0);

            double4x4 a1 = double4x4(112.79684668071422, -503.27416181158003, -79.635249413380052, -131.0041454448384, 147.89369566174867, -15.70865417258284, 188.75845274178243, 307.79193582562357, -406.667706917351, 181.47510703908051, -188.69222578252305, -505.2156915633081, -372.24192898918034, -4.0317671317754957, 83.767736235525376, -30.631410374600193);
            double4x4 r1 = double4x4(111.79684668071422, -504.27416181158003, -80.635249413380052, -132.0041454448384, 146.89369566174867, -16.70865417258284, 187.75845274178243, 306.79193582562357, -407.667706917351, 180.47510703908051, -189.69222578252305, -506.2156915633081, -373.24192898918034, -5.0317671317754957, 82.767736235525376, -31.631410374600193);
            TestUtils.AreEqual(--a1, r1);

            double4x4 a2 = double4x4(-436.90656181653333, 345.02153913351776, 4.7353689692613443, -68.653318198701982, 481.496122346025, 463.39140985132724, -357.67329399551886, 153.32965023505017, -233.62431751639781, -35.238318221288864, 340.61965743667429, 259.92884195033878, 335.35490886091952, 85.364882747347, -1.3939745432668929, -407.41038651364408);
            double4x4 r2 = double4x4(-437.90656181653333, 344.02153913351776, 3.7353689692613443, -69.653318198701982, 480.496122346025, 462.39140985132724, -358.67329399551886, 152.32965023505017, -234.62431751639781, -36.238318221288864, 339.61965743667429, 258.92884195033878, 334.35490886091952, 84.364882747347, -2.3939745432668929, -408.41038651364408);
            TestUtils.AreEqual(--a2, r2);

            double4x4 a3 = double4x4(-145.79341251486608, -337.44545022465542, -464.67419812859697, 226.80292831491818, 15.319232232551713, 431.07077404068355, 273.0958756288029, -3.1083834185769774, 334.14676848712691, 26.124073755985137, 14.661183125647312, 239.30467449841308, 32.206458345151759, 288.58896578875783, -297.482929129844, -154.8607662445217);
            double4x4 r3 = double4x4(-146.79341251486608, -338.44545022465542, -465.67419812859697, 225.80292831491818, 14.319232232551713, 430.07077404068355, 272.0958756288029, -4.1083834185769774, 333.14676848712691, 25.124073755985137, 13.661183125647312, 238.30467449841308, 31.206458345151759, 287.58896578875783, -298.482929129844, -155.8607662445217);
            TestUtils.AreEqual(--a3, r3);
        }

        [TestCompiler]
        public static void double4x4_operator_postfix_dec()
        {
            double4x4 a0 = double4x4(-376.59242719066907, 16.969734438215255, -0.25066399585949739, -202.32328734282555, 409.55752940175944, 47.856652520530247, -281.11170376516492, -262.062590959511, -182.40572866350681, 450.12809559801974, -129.23265582380475, -332.15495768755443, -261.00890052551819, 205.46112570793423, -230.22777878038016, -483.06653784358247);
            double4x4 r0 = double4x4(-376.59242719066907, 16.969734438215255, -0.25066399585949739, -202.32328734282555, 409.55752940175944, 47.856652520530247, -281.11170376516492, -262.062590959511, -182.40572866350681, 450.12809559801974, -129.23265582380475, -332.15495768755443, -261.00890052551819, 205.46112570793423, -230.22777878038016, -483.06653784358247);
            TestUtils.AreEqual(a0--, r0);

            double4x4 a1 = double4x4(378.64123433578811, -192.17785772689518, -357.05418960985457, -396.30206627226528, 279.42425287860647, 115.86774092347719, -20.823201427619551, 323.40538063803933, 379.15614026559342, 311.29903068733358, 409.22248644811214, -428.25672479544613, -425.2883748604396, -194.64129671577427, -258.84836089743692, -208.98576388553982);
            double4x4 r1 = double4x4(378.64123433578811, -192.17785772689518, -357.05418960985457, -396.30206627226528, 279.42425287860647, 115.86774092347719, -20.823201427619551, 323.40538063803933, 379.15614026559342, 311.29903068733358, 409.22248644811214, -428.25672479544613, -425.2883748604396, -194.64129671577427, -258.84836089743692, -208.98576388553982);
            TestUtils.AreEqual(a1--, r1);

            double4x4 a2 = double4x4(-313.42591657928466, 176.78949864990523, -370.78628438095853, 64.903882295314133, 449.63778540568319, -112.10504608606226, -203.43741021092859, 417.13731093757656, -197.3473556960688, 446.02335020807732, 239.97454058377753, 350.61805431480434, -264.7472652237617, 186.44167980292889, 353.75952093385138, 68.234193118398139);
            double4x4 r2 = double4x4(-313.42591657928466, 176.78949864990523, -370.78628438095853, 64.903882295314133, 449.63778540568319, -112.10504608606226, -203.43741021092859, 417.13731093757656, -197.3473556960688, 446.02335020807732, 239.97454058377753, 350.61805431480434, -264.7472652237617, 186.44167980292889, 353.75952093385138, 68.234193118398139);
            TestUtils.AreEqual(a2--, r2);

            double4x4 a3 = double4x4(-240.61070048092432, -269.28632772587537, -101.80513792010265, -492.29036091840379, -507.07826041946106, 413.10199351473807, -491.42746256824, -13.728667980864941, -481.598610863834, 248.55762183319666, -178.33419021327711, -345.80586616406492, -269.1173538030672, 132.7693923137939, -382.38429492636783, 388.83080619798545);
            double4x4 r3 = double4x4(-240.61070048092432, -269.28632772587537, -101.80513792010265, -492.29036091840379, -507.07826041946106, 413.10199351473807, -491.42746256824, -13.728667980864941, -481.598610863834, 248.55762183319666, -178.33419021327711, -345.80586616406492, -269.1173538030672, 132.7693923137939, -382.38429492636783, 388.83080619798545);
            TestUtils.AreEqual(a3--, r3);
        }


    }
}
